----------------------- PLEASE READ THIS ---------------------------!!!

-- This input file is set up to run for regression check
-- Please make sure you DO NOT MODIFY AND PUSH it to the repository
                                                                          
--------------------------------------------------------------------!!!


-- This is a sample Musubi configuration file in lua format
-- 
-- WARNING!!!
-- LEAVE THIS FILE UNCHANGED IN THE REPOSITORY
-- 
-- Thank you!
--
--

-- load lua variables from simParam.lua
require "common"
bc_kind_1 = 'wall'
bc_kind_1 = 'spc_molefrac'
bc_kind_1 = 'spc_moments_molefrac'

bc_kind_2 = 'spc_moleflux'
bc_kind_2 = 'moments_wall'
bc_kind_2 = 'spc_moments_moleflux'
bc_kind_2 = 'wall'
bc_kind_2 = 'spc_moments_wall'


if bc_type == 'moments' then
  bc_kind_1 = 'spc_moments_molefrac'
  bc_kind_2 = 'spc_moments_moleflux'
end  
if bc_type == 'BounceBack' then
  bc_kind_1 = 'spc_molefrac'
  bc_kind_2 = 'spc_moleflux'
  bc_kind_2 = 'wall'
end

-- simulation paramters
io_buffer_size = 1
printRuntimeInfo = false

-- communication pattern
--isend_irecv_overlap gathered_type isend_irecv typed_isend_irecv
commpattern = 'isend_irecv'
-- Simulation name
simulation_name = 'stefantube'
mesh = 'mesh/'

-- Interpolation method
-- average, copyfirst, linear, debug
interpolation_method = 'average'                   
scaling = 'diffusive'

ebug = {debugMode = true, debugFiles = true, verbose =  true, verboseLevel = 100}
--logging = {level=10}

-- Time step settings
--tmax = 100
--tmax_p = tmax*dt
interval_p = tmax_p/10
--interval = 1000
sim_control = {
  time_control = {
    min = 0,
    max = {sim=tmax_p},
   interval = {sim=interval_p }
    --max = {sim=tmax_p,iter=tmax},
   --interval = {sim=interval_p, iter=interval }
   },
  abort_criteria = {
    stop_file = 'stop',
    steady_state = true
  }
} 
--time = {useIterations = true,
--        min = 0, max = 1, interval = 1 }

physics = { --rho0 = rho0, 
            dt = dt, 
            moleDens0=1000.0,
            molWeight0 = math.min(mAir,mAcetone,mMethanol) 
          }

-- scheme model for single fluid simulation
scheme = {
  identify = {
      label = 'mix',
      kind = 'multi-species_liquid', 
      relaxation = 'bgk', 
      --relaxation = 'mrt', 
-- scheme layout
      --layout = 'd3q19'
      layout = 'd3q19'
  },

  mixture = { rho0 = rho0, moleDens0 = 1000.0, 
              omega_diff = 2.0,
              --kine_shear_viscosity = nu_p,
              omega_kine = 2.0,
              theta_eq = 1.0,
              initial_condition = { pressure = 0.0}--TGV_kinematicPressure }
            },
  -- field which defines fluid or specie
  -- Single fluid simulation
  field = {{
    label = 'Acetone'
-- species properties
   ,species = { molweight = mAcetone, 
                diff_coeff = { diff_diag, diff_Ace_Met, diff_Ace_Air } }
-- Initial condition
   ,initial_condition = { 
      molefraction = IC_Acetone_Linear,
      velocityX = 0.0,
      velocityY = 0.0,
      velocityZ = 0.0
    }
   ,boundary_condition = {
     {
       label = 'inlet',
       kind = bc_kind_1,
       molefraction = moleFrac_Ace_In
     },
     {
       label = 'outlet',
       kind = bc_kind_1,
       molefraction = moleFrac_Ace_Out
     }
    }
  }
 ,{
    label = 'Methanol'
   ,species = { molweight = mMethanol, 
                diff_coeff = { diff_Ace_Met, diff_diag, diff_Met_Air } }
   ,initial_condition = {
      molefraction = IC_Methanol_Linear,
      velocityX = 0.0,
      velocityY = 0.0,
      velocityZ = 0.0
    }
   ,boundary_condition = {
     {
       label = 'inlet',
       kind = bc_kind_1,
       molefraction = moleFrac_Met_In
     },
     {
       label = 'outlet',
       kind = bc_kind_1,
       molefraction = moleFrac_Met_Out
     }
    }
  }
 ,{
    label = 'Air'
   ,species = { molweight = mAir, 
                diff_coeff = { diff_Ace_Air, diff_Met_Air, diff_diag } }
   ,initial_condition = {
      molefraction = IC_Air_Linear,
      velocityX = 0.0,
      velocityY = 0.0,
      velocityZ = 0.0
    }
   ,boundary_condition = {
     {
       label = 'inlet',
       kind = bc_kind_2,
       molefraction = moleFrac_Air_In,
       molefluxX = 0.0,
       molefluxY = 0.0,
       molefluxZ = 0.0,
       ind = 'spc_molediff_flux',
       molediff_fluxX = 0.0,
       molediff_fluxY = 0.0,
       molediff_fluxZ = 0.0
     },
     {
       label = 'outlet',
       kind = bc_kind_1,
       molefraction = moleFrac_Air_Out,
     }
    }

  }
  }
  -- add initial condition to variable system
  ,add_variable = { name = 'initialMoleFrac', 
    ncomponents = 1, 
    initialMoleFrac = { 
      { kind = 'combined', spatial = IC_Acetone  },
      { kind = 'combined', spatial = IC_Methanol },
      { kind = 'combined', spatial = IC_Air }
    }
  }  

, 
tracking = {
  {
   label = 'line', 
   variable = {{'Acetone_molefrac'},{'Methanol_molefrac'},{'Air_molefrac'},{'molefrac'}},
   folder = './tracking/',
   shape = {kind = 'canoND', object= {origin={0.0,dx,dx},
                                      vec={length,0.0,0.0},
                                      segments =nLength+2 }
           },
   format = 'asciiSpatial',
   time_control = {min = tmax_p, max = tmax_p, interval = tmax_p}, 
  },
  {
   label = 'point', 
   variable = {{'Acetone_molefrac'},{'Methanol_molefrac'},{'Air_molefrac'},
               {'Acetone_moleflux_phy'},{'Methanol_moleflux_phy'},{'Air_moleflux_phy'},
               {'moleflux'},{'velocity'}},
   folder = './tracking/',
   shape = {kind = 'canoND', object= {origin={0.0,dx,dx} } },
   format = 'ascii',
   time_control = {min = 0, max = tmax_p, interval = dt*10}, 
  },
  {
   label = 'velMax', 
   variable = {
               {'velocity'}},
   folder = './tracking/',
   shape = {kind = 'all'}, 
   reduction = 'max',
   format = 'ascii',
   time_control = {min = 0, max = tmax_p, interval = dt*10}, 
  },
  { label = 'convergence',
    variable = {{'density'}}, 
    shape = {kind = 'canoND', object = {origin ={length*0.5,dx,dx}}},
    time_control = {min = 0, max = tmax_p, interval = 10*dt},
    format='convergence',
    convergence = {norm='average', nvals = 50, absolute = true,
    condition = { threshold = 1.e-12, operator = '<=' }}
  }
  }
}


