-- inner to outer dia ratio
inner_to_outer_ratio = 0.5
dia_outer = 1 --m
dia_inner = dia_outer * inner_to_outer_ratio
rad_inner = dia_inner/2.0
rad_outer = dia_outer/2.0
nDia_inner = 64
dx = dia_inner/nDia_inner
nDia_outer = math.ceil(dia_outer/dx)
nLength_bnd = 2*nDia_outer + 4
level = math.ceil(math.log(nLength_bnd)/math.log(2))
length_bnd = (2^level)*dx
--length_bnd = 2*dia_outer
--level = 9
--dx = length_bnd/2^level
--nLength = length_bnd/dx
qVal = true

dx_half = dx*0.5
dx_eps = length_bnd/2^20

stlFolder = './'

folder = 'mesh/'--..subprefix
NOdebug = {debugMode = true, debugFiles=true}
timing_file = 'sdr_timing.res'

-- boundingbox: two entries: origin and length in this
-- order, if no keys are used
bounding_cube = {origin = {-length_bnd/2.0, -length_bnd/2.0, -length_bnd/2.0-dx/2.0},
               length = length_bnd}
logging = {level=10}
minlevel = level

spatial_object = {
  {
    attribute = {
      kind = 'seed',   ----seed
    },
    geometry = {
      kind = 'canoND',
      object = {
        origin = { rad_inner+dx,rad_inner+dx,0.0 },
        --origin = { 2*dia_inner,0.0,0.0},
        --vec = { dia_outer/2.0 - 2*dia_inner, 0.0,0.0}
      }
    }
  },
  {
    attribute = {
      kind = 'periodic',
      label = 'periodic',
    },
    geometry = {
      kind = 'periodic',
      object = {
        plane1={
          origin = {-length_bnd/2.0,-length_bnd/2.0, -dx},
          vec = {
            {0.0, length_bnd, 0.0},
            {length_bnd, 0.0, 0.0},
          }
        },
        plane2={
          origin = {-length_bnd/2.0,-length_bnd/2.0,dx},
          vec = {
            {length_bnd, 0.0, 0.0},
            {0.0, length_bnd, 0.0}
          }
        },
      }
    },
  },
  {
    attribute = {
      kind = 'boundary',
      label = 'inner',
      calc_dist = qVal,
      flood_diagonal = true
    },
    geometry = {
      kind = 'stl',
      object = {
        filename = stlFolder..'cylinder_Dia1m.stl'
      }
    },
    transformation = {
      deformation = {inner_to_outer_ratio,inner_to_outer_ratio, 1.0}
    }
  },
  {
    attribute = {
      kind = 'boundary',
      label = 'outer',
      calc_dist = qVal,
      flood_diagonal = true
    },
    geometry = {
      kind = 'stl',
      object = {
        filename = stlFolder..'cylinder_Dia1m.stl'
      }
    },
  },

}

