show_plot = True
linestyle = ['r-','y-','g-','m-','k-.','b-','c-','r--']
markerstyle = ['x','+','v','o','D','','','']

plot  = []
font_size = 12
#figsize=[5,4]
set_majorgrid = True
font_family = 'serif'
font_type = 'Times New Roman'

# mus_path for different outlet please
# means: Array mus_path must contain only paths for one kind of outlet. This generates plots with varying omega
# over fixed outletBC.

mus_path = $!musubi_path!$
omega = $!musubi_omega!$
outlet = $!musubi_outletBC!$ 
outlet_a = $!musubi_outletBC!$

# Velocity
plot.append(dict(kind = 'xy', 
            data=[mus_path[-1]+'/tracking/*vel_spatial*.res'],
            col=[2,5],dtype='float',
            startplot = True, endplot = False,
            label = 'Analytic', ls = 'k-', marker = dict(style='x',fillstyle='none')))

for iFile in range(len(mus_path)):
  ePlot = False
  if iFile == (len(mus_path)-1):
    ePlot = True

  omega_i = float(omega[iFile-1])
  plot.append(dict(kind = 'xy', 
              data=[mus_path[iFile-1]+'/tracking/*vel_spatial*.res'],
              col=[2,4],dtype='float', 
              startplot = False, endplot = True,
              xlabel = 'y (m)', 
              ylabel = 'Velocity (m/s)',
              label = '$\omega =$'+str(omega_i), ls = linestyle[iFile],
#              #marker=dict(style=markerstyle[iFile],fillstyle='none'),
              legend=dict(loc=8),
              title = 'Velocity profile for outletBC = '+str(outlet_a[0]),
              format = 'png', figname = 'Velocity_Profile'+str(outlet[0])))

# Pressure
plot.append(dict(kind = 'xy', 
            data=[mus_path[-1]+'/tracking/*press_line*.res'],
            col=[1,5],dtype='float',
            startplot = True, endplot = False,
            label = 'Analytic', ls = 'k-', marker = dict(style='x',fillstyle='none')))

for iFile in range(len(mus_path)):
  ePlot = False
  if iFile == (len(mus_path)-1):
    ePlot = True

  omega_i = float(omega[iFile-1])
  plot.append(dict(kind = 'xy', 
              data=[mus_path[iFile-1]+'/tracking/*press_line*.res'],
              col=[1,4],dtype='float', 
              startplot = False, endplot = True,
              xlabel = 'y (m)', 
              ylabel = 'Pressure (Pa)',
              label = '$\omega =$'+str(omega_i), ls = linestyle[iFile], 
              legend=dict(loc=1),
#              #marker=dict(style=markerstyle[iFile]),
              title = 'Pressure drop for outletBC = '+str(outlet_a[0]),
              format = 'png', figname = 'PressureDrop'+str(outlet[0])))

# Wall shear stress
plot.append(dict(kind = 'xy', 
            data=[mus_path[-1]+'/tracking/*wss_spatial*.res'],
            col=[2,4],dtype='float',
            startplot = True, endplot = False,
            label = 'Analytic', ls = 'k-', marker = dict(style='x',fillstyle='none')))

for iFile in range(len(mus_path)):
  ePlot = False
  if iFile == (len(mus_path)-1):
    ePlot = True

  omega_i = float(omega[iFile-1])
  plot.append(dict(kind = 'xy', 
              data=[mus_path[iFile-1]+'/tracking/*wss_spatial*.res'],
              col=[2,5],dtype='float', 
              startplot = False, endplot = True,
              xlabel = 'y (m)', 
              ylabel = 'WSS (Pa)',
              label = '$\omega =$'+str(omega_i), ls = linestyle[iFile], 
              legend=dict(loc=9),
#              #marker=dict(style=markerstyle[iFile]),
              title = 'Wall shear stress for outletBC = '+str(outlet_a[0]),
              format = 'png', figname = 'WSS_Profile'+str(outlet[0])))


#velocity center line
for iFile in range(len(mus_path)):
  sPlot = False
  ePlot = False
  if iFile == 0:
    sPlot = True
  if iFile == (len(mus_path)-1):
    ePlot = True

  omega_i = float(omega[iFile-1])
  plot.append(dict(kind = 'xy', 
              data=[mus_path[iFile-1]+'/tracking/*vel_centerLine*.res'],
              col=[1,4],dtype='float',
              startplot = sPlot, endplot = ePlot,
              xlabel = 'x (m)', 
              ylabel = 'Velocity (m/s)',
              label = '$\omega =$'+str(omega_i), ls = linestyle[iFile],
              title = 'Velocity center line for outletBC = '+str(outlet_a[0]),
              format = 'png', figname = 'VelLine_Profile'+str(outlet[0]) ))

# probe pressure
for iFile in range(len(mus_path)):
  sPlot = False
  ePlot = False
  if iFile == 0:
    sPlot = True
  if iFile == (len(mus_path)-1):
    ePlot = True

  omega_i = float(omega[iFile-1])
  plot.append(dict(kind = 'xy', 
              data=[mus_path[iFile-1]+'/tracking/*probe*.res'],
              col=[1,2],dtype='float',
              startplot = sPlot, endplot = ePlot,
              xlabel = 'time (s)', ylabel = 'Pressure ($N/m^2$)',
              legend=dict(loc=4),
              label = '$\omega =$'+str(omega_i), ls = linestyle[iFile],
              title = 'Pressure over time for outletBC = '+str(outlet_a[0]),
              format='png', figname = 'pressureOverTime'+str(outlet[0])))

# probe velocity
for iFile in range(len(mus_path)):
  sPlot = False
  ePlot = False
  if iFile == 0:
    sPlot = True
  if iFile == (len(mus_path)-1):
    ePlot = True

  omega_i = float(omega[iFile-1])
  plot.append(dict(kind = 'xy', 
              data=[mus_path[iFile-1]+'/tracking/*probe*.res'],
              col=[1,3],dtype='float',
              startplot = sPlot, endplot = ePlot,
              xlabel = 'time (s)', ylabel = 'Velocity X ($m/s$)',
              label = '$\omega =$'+str(omega_i), ls = linestyle[iFile],
              title = 'Velocity over time for outletBC = '+str(outlet_a[0]),
              format='png', figname = 'velocityOverTime'+str(outlet[0])))
