import os
#apesFolder = '/work/ws-tmp/gk779-SimTec-II/apes_executables/'
apesFolder = os.getenv('HOME')+'/apes/'
# Production directory - default production directory is 'prod'
# comment out if you don't want user defined production directory
prod_dir = 'convergence_incomp_PinExpol_PoutExpol'
loglevel = 'info'
#mail_address = 'mail@id'
mail_address = None

#run_seeder = False
run_seeder = True

#run_musubi = False
run_musubi = True

submit_job = False
#submit_job = True

#run_gleaner = False
run_gleaner = True

grep_performance = False

shepherd_jobs = []

shepherd_jobs.append(dict(executable=apesFolder+'/seeder/build/seeder',
                          template='seeder.template',
                          extension='lua',
                          run_exec = run_seeder,
                          run_command = '',
                          params = [['refineLevel', 0,1,2,3],
                                   ],
                          additional_params = dict(dx_ref=1.0/10.0),
                          abort_failure = True,
                          create_subdir = ['mesh'],
                          prefix = 'sdr',
                          label = 'seeder'))

shepherd_jobs.append(dict(executable=apesFolder+'/musubi/build/musubi',
                          template='musubi.template',
                          extension='lua',
                          run_exec = run_musubi,
                          run_command = 'mpirun -np 12',
                          params = [["omega", 1.1,1.6,1.9], 
                                   ],
                          additional_params = dict(MESH='../mesh/', Re=10,
                                                   inletBC = 'outlet_expol',
                                                   outletBC = 'outlet_expol',
                                                   wallBC = 'wall',
                                                   qVal_wall = 0.5,
                                                   scheme_kind = 'lbm_incomp'
                                                   ),
                          abort_failure = True,
                          create_subdir = ['tracking','restart'],
                          prefix = 'mus',
                          depend = ['seeder'],
                          create_depend_path = True,
                          label = 'musubi'))

shepherd_jobs.append(dict(executable=None,
                     template='printSimParam.template',
                     extension='lua',
                     run_exec = False,
                     run_command = '',
                     abort_failure = True,
                     depend = ['seeder','musubi'],
                     create_depend_path = True,
                     label = 'print'))

#shepherd_jobs.append(dict(executable=None,
#                     template='horus.template',
#                     extension='sh',
#                     run_exec = submit_job,
#                     run_command = 'sbatch',
#                     params = [
#                               ["nNodes", 1]
#                              ],
#                     abort_failure = True,
#                     create_dir = False,
#                     create_depend_path = True,
#                     depend = ['musubi'],
#                     label = 'horus'))

#shepherd_jobs.append(dict(executable=None,
#                          template = 'plot_track.template',
#                          extension='py',
#                          run_exec = run_gleaner,
#                          run_command = 'python3.7',
#                          depend = ['seeder','musubi'],
#                          #depend = ['musubi'],
#                          abort_failure = True,
#                          run_last = True,
#                          create_depend_path = True,
#                          create_depend_params = True,
#                          label = 'plot_track'))

shepherd_jobs.append(dict(executable=None,
                          template = 'plot_l2error.template',
                          extension='py',
                          run_exec = run_gleaner,
                          run_command = 'python3.7',
                          depend = ['seeder','musubi'],
                          abort_failure = True,
                          #depend = ['musubi'],
                          run_last = True,
                          create_depend_path = True,
                          create_depend_params = True,
                          label = 'plot_l2error'))

