# This script used by regression check to run plain channel 2D and send results
# to the following email address
# author: Jiaxing Qi
#!/bin/bash
executable=EXEC

error_flag=0

export email=qijiaxing@gmail.com

# parameters one can alter
export LEVEL=6
export Re=30
export KIND="lbm_incomp"
export MULTI="n"
export SCALING='diffusive'
export INTP='linear'

echo ------------------------------------------------------
echo Evaluating Plain Channel 2D Test case.
echo Re: $Re
echo Mesh level: $LEVEL
echo LBM kind: $KIND
echo Author: Jiaixng Qi
echo Have fun!
echo ------------------------------------------------------

if [ -z "$email" ]; then
  echo "Please input your email address:"
  read email_input
  export email=$email_input
fi

export prefix=L${LEVEL}_Re${Re}_${SCALING}_${INTP}
export prefix=L${LEVEL}_Re${Re}_single_level

# export results and pictures file names so gnuplot can also use them.
export vel_file=tracking/${prefix}_vel_spatial.res
export wss_file=tracking/${prefix}_wss_spatial.res
export strain_file=tracking/${prefix}_strain_spatial.res
export p_file=tracking/${prefix}_p_spatial.res
export inlet_file=tracking/${prefix}_inlet_spatial.res
export outlet_file=tracking/${prefix}_outlet_spatial.res

export results_tar=${prefix}_results.tar

export vel_pic=pictures/${prefix}_vel_spatial.eps
export wss_pic=pictures/${prefix}_wss_spatial.eps
export strain_pic=pictures/${prefix}_strain_spatial.eps
export p_pic=pictures/${prefix}_pressureDrop.eps
export vel_along_pic=pictures/${prefix}_vel_along.eps
export bc_vel_pic=pictures/${prefix}_bc_vel.eps
export bc_strain_pic=pictures/${prefix}_bc_strain.eps
export bc_p_pic=pictures/${prefix}_bc_p.eps

export musubi_log=logs/${prefix}_musubi.log
export seeder_log=logs/${prefix}_seeder.log

# create folders and delete old results files
echo "Create directory and delete old files"
[ ! -d mesh ] && mkdir mesh
[ -d tracking ] && rm -r tracking/
mkdir tracking
[ -d pictures ] && rm -r pictures/
mkdir pictures
[ -d output ]   && rm -r output/
mkdir output
[ -d logs ]     && echo 'logs folder found'     || mkdir logs
[ -d archives ] && echo 'archives folder found' || mkdir archives

# ../../../../seeder/build/seeder | tee ${seeder_log}
# runSeeder outside of this script
#echo run seeder
#~/apes/seeder/build/seeder | tee 
# cat 'Seeder was run before this script' > ${seeder_log}
touch ${seeder_log}

# run MUSUBI
echo run musubi
mpirun -n 2 ${executable} | tee ${musubi_log}

# print important parameters
lua param.lua >> ${musubi_log}

# collect results into target files
echo collect results
cat tracking/*vel_spatial*res >> $vel_file
cat tracking/*wss_spatial*res >> $wss_file
cat tracking/*strainRate_spatial*res >> $strain_file
cat tracking/*pressureDrop*res >> $p_file

echo 'Velocity magnitude error l2norm across channel' >> ${musubi_log}
tail -n 2 tracking/*vel_l2norm*res >> ${musubi_log}

echo 'Shear stress error l2norm across channel' >> ${musubi_log}
tail -n 2 tracking/*wss_l2norm*res >> ${musubi_log}

cat tracking/*inlet_spatial*res >> $inlet_file
cat tracking/*outlet_spatial*res >> $outlet_file

# create results achivies
tar cvf ${results_tar} $vel_file
tar rvf ${results_tar} $wss_file
tar rvf ${results_tar} $strain_file
tar rvf ${results_tar} $inlet_file
tar rvf ${results_tar} $oulet_file
tar rvf ${results_tar} $p_file

# plot results
module rm gcc 2>&1
gnuplot plot_spatial.gpl
module add gcc 2>&1

# send plot to email address
python2.7 send_email.py

echo Channel 2D single level single run testcase finished!
echo "Done.        with errorflag" $error_flag
exit $error_flag
