require "common"

simulation_name = 'channel2D'
debug_mode = false

time = {useIterations = true,
        max = tmax, interval = tmax/10}
estart = {
  read = 'restart/level'..level..'/'..simulation_name..'_lastHeader.lua',
  --write = 'restart/level'..level..'/', 
  --time = { interval  = 1, min = tmax, max = tmax,}
}

add_variable = {
  { name='vel_an', ncomponents=1, vel_an=velA },
  { name='wss_an', ncomponents=1, wss_an=wssA }
}

utput = { 
  active = true,
  folder = 'output/',
  vtk = true,
  time = { min = tmax, max = tmax, interval = 1},
}

tracking = {
--{  label = 'pressureDrop_L'..level,
--  variable = {
--    { name = 'density', ncomponents = 1 }
--  },
--  shape = { kind = 'canoND', object = {origin = { -length/4, 0.0, dx/2 },
--                                       --vec = { length/2, 0.0, 0.0},
--                                       segments = {1} } },
--  time = { min = 1, max = tmax, interval = 10 },
--  folder = './tracking/',
--  format = 'ascii',}

{ label = 'wss_spatial_L'..level,
  variable = {
    {'wss'},
    {'wss_an'},
    {name = 'difference', ncomponents = 1, dep = {'wss','wss_an'},},
              },
  shape = { kind = 'canoND',
            object = {origin = { 0.0, -height/2, dx/2},
                      vec = { 0.0, height, 0.0},
                      segments = {200} }},
  time = { min = tmax, max = tmax, interval = 10 },
  folder = './tracking/',
  format = 'asciiSpatial',},

{ label = 'wss_l2norm_L'..level,
  variable = {
    {name = 'difference', ncomponents = 1, dep = {'wss','wss_an'},},
    {'wss_an'},
              },
  shape = { kind = 'canoND',
            object = {origin = { 0.0, -height/2, dx/2},
                      vec = { 0.0, height, 0.0},
                      segments = {100} }},
  time = { min = tmax, max = tmax, interval = 100 },
  reduction = {'l2norm', 'l2norm'},
  folder = './tracking/',
  format = 'asciiSpatial',},

{ label = 'vel_spatial_L'..level,
  variable = {
    {'velMag'},
    {'vel_an'},
    {name = 'difference', ncomponents = 1, dep = {'velMag','vel_an'},},
              },
  shape = { kind = 'canoND',
            object = {origin = { 0.0, -height/2, dx/2},
                      vec = { 0.0, height, 0.0},
                      segments = {200} }},
  time = { min = tmax, max = tmax, interval = 10 },
  folder = './tracking/',
  format = 'asciiSpatial',},

{ label = 'vel_l2norm_L'..level,
  variable = {
    {name = 'difference', ncomponents = 1, dep = {'velMag','vel_an'},},
    {'vel_an'},
              },
  shape = { kind = 'canoND',
            object = {origin = { 0.0, -height/2, dx/2},
                      vec = { 0.0, height, 0.0},
                      segments = {100} }},
  time = { min = tmax, max = tmax, interval = 100 },
  reduction = {'l2norm', 'l2norm'},
  folder = './tracking/',
  format = 'asciiSpatial',},
}   -- trakcing table

fluid = { omega = omega, rho0 = rho0 }

initial_condition = { pressure = p0, velocityX = velA, velocityY = 0.0, velocityZ = 0.0 }
identify = {label = 'channel', kind = 'lbm', layout = 'd3q19'}

boundary_condition = {
{ label = 'outlet',  kind = 'outlet_expol', pressure = p0, },
{ label = 'top_wall', kind = 'wall'},
{ label = 'bottom_wall', kind = 'wall'},
                    } -- boundary table
if usePeriodic then
  table.insert( boundary_condition,
        { label = 'inlet',   kind = 'inlet_ubb',
          velocityX = {
            kind = 'combined',
            transient= {
              predefined='smooth',
              min_factor=0.0, max_factor=velMax, from_time=0, to_time=tmax/4},
            spatial = {
              predefined='parabol',
              shape = { kind = 'canoND', 
                        object = { origin = { -length/2+dx, -R*dx, dx/2},
                                   vec = { 0.0, 2*R*dx, 0.0 }
                                 }
                      } -- shape table
                      } -- spatial table
                      }, -- velX table
          velocityY = 0.0,
          velocityZ = 0.0,
        })
else
  table.insert( boundary_condition,
        { label = 'left',   kind = 'inlet_ubb',
          velocityX = {
            kind = 'combined',
            transient= {
              predefined='smooth',
              min_factor=0.0, max_factor=velMax, from_time=0, to_time=tmax/4},
            spatial = {
              predefined='parabol',
              shape = { kind = 'canoND', 
                        object = { origin = { -length/2+dx, -R*dx, R*dx},
                                   vec = { {0.0, 2*R*dx, 0.0}, {0.0, 0.0, R*dx} }
                                 }
                      } -- shape table
                      } -- spatial table
                      }, -- velX table
          velocityY = 0.0,
          velocityZ = 0.0,
        })
  table.insert( boundary_condition,
      { label = 'front', kind = 'wall' } )
  table.insert( boundary_condition,
      { label = 'back', kind = 'wall' } )
end
