----------------------- PLEASE READ THIS ---------------------------!!!

-- This input file is set up to run for regression check
-- Please make sure you DO NOT MODIFY AND PUSH it to the repository
                                                                          
--------------------------------------------------------------------!!!


-- Musubi configuration file. 
-- This is a LUA script.
require 'seeder'
tracking_fol = './'
restart_fol = 'restart/'
printRuntimeInfo = false

-- Characteristic length of the domain
l_ref = 1.0
-- Maximum mesh refinement level
level = 5
-- Reynolds number
Re = 100
-- lattice velocity
u_in_L = 0.09
-- physical discretization step size
dx = l_ref/(2^level)
rho0_l = 1.0
cs2_l = 1./3.
p0_l = rho0_l*cs2_l

-- relaxtion time
omega = 1.0/(3.0*u_in_L*nLength/Re+0.5)

timing_file = 'timing.res'

-- Simulation name
simulation_name = 'lidcavity'

-- Mesh information
mesh = 'mesh/'

logging = {level=5}
-- Time step settings
tmax           =  5000*Re     -- total iteration number
sim_control = {
  time_control = { 
    max = {iter=tmax},
    interval = {iter=tmax/10}
  },
  abort_criteria = {
    steady_state = true,
    convergence = { 
      variable = {'density','vel_mag'}, 
      shape = { kind = 'canoND', object ={ origin = {length/2.0,length/2.0,0.0}}},
      time_control = {min = {iter=0}, max = {iter=tmax}, interval = {iter=10}},
      norm='average', nvals = 100, absolute = true,
      reduction = {'average','average'}, 
      condition = {
        { threshold = 1.e-10, operator = '<=' },
        { threshold = 1.e-10, operator = '<=' }
      }  
    }
  }   
}  

-- restart 
NOrestart = {
  ead = restart_fol..'lidcavity2D_lastHeader.lua',
  write = restart_fol,
  -- without timeControl restart will be dumped by default at end
  -- of simulation when write restart is set
  --time_control = { 
  --  min = {iter=tmax}, 
  --  max = {iter=tmax},
  --  interval={iter=tmax}
  --}
}


-- physics setting
-- Fluid properties
fluid = { omega = omega }

-- relaxation time Omega
-- Re = 100, omega = 1.625
-- Re = 400, omega = 1.891
-- Re = 1000, omega = 1.955
-- omega     =  1.891


identify = {layout='d3q19',kind='lbm_incomp'}
-- Initial condition 
initial_condition = { pressure = p0_l, 
                      velocityX = 0.0,
                      velocityY = 0.0,
                      velocityZ = 0.0 }

-- Boundary conditions
boundary_condition = {  
 { label = 'top', 
  kind = 'inlet_ubb', 
  velocity = 'inlet_vel'
 }
,{ label = 'bottom', 
   kind = 'wall'} 
,{ label = 'left', 
   kind = 'wall'} 
,{ label = 'right', 
   kind = 'wall'}
}

-- user variables
variable = {
  {
    name = 'inlet_vel',
    ncomponents = 3,
    vartype = 'st_fun',
    st_fun = {
      predefined = 'combined',
      temporal  = {
        predefined = 'smooth',
        min_factor = 0, max_factor = u_in_L,
        from_time = 0, to_time = tmax/4
      },
      spatial = {
        const = {1.0,0.0,0.0}
      }
    }  
  },
}

-- Tracking              
tracking = {
{ label = 'point_vel',
  folder = tracking_fol,
  variable = {'velocity'}, 
  shape = { kind = 'canoND', object ={ origin = {length/2.0,length/2.0,0.0}}},
  time_control = {min = {iter=1}, max = {iter=tmax}, interval = {iter=100}},
  output = {format = 'ascii'}
}, 
{ 
  label = 'verticalLine_vel',
  folder = tracking_fol,
  variable = {'velocity'},
  shape = { kind = 'canoND', object = { 
                               origin = { length/2.0,0.,0.0}, 
                               vec = {0.,length,0.}, 
                               segments=nLength+2}}, 
  output = {format='asciiSpatial'},
  time_control = {min = {iter=tmax}, max ={iter=tmax},interval={iter=tmax}},
},
{ 
  label = 'horizondalLine_vel',
  folder = tracking_fol,
  variable = {'velocity'},
  shape = { kind = 'canoND', object = { 
                               origin = { 0.0,length/2.0,0.0}, 
                               vec = {length,0.,0.0}, 
                               segments=nLength+2}}, 
  output = {format='asciiSpatial'}, 
  time_control = {min = {iter=tmax}, max ={iter=tmax},interval={iter=tmax}},
},
--{
--  label = 'hvs',
--  folder = tracking_fol,
--  variable = {'pressure','velocity','shear_stree'},
--  shape = {kind='all'},
--  time_control = {min = {iter=tmax}, max = {iter=tmax}, interval = {iter=tmax}},
--  output = {format='harvester'}
--},
--{
--  label = 'para',
--  folder = tracking_fol,
--  variable = {'pressure','velocity','shear_stree'},
--  shape = {kind='all'},
--  time_control = {min = {iter=tmax}, max = {iter=tmax}, interval = {iter=tmax}},
--  output = {format='vtk', iter_filename=false}
--},
}

