##This input file print deltaP and Stroudal number on the screen
############################
##acoustic scaling
############################

import math
from units import *

plot  = []
show_plot = True

height =  0.41
u_in_L = 0.05
u_in_phy = 1.5

##deltaP
nHeight = 50
dx = getdxFromnL(height,nHeight)
dt = getdt_acoustic(dx,u_in_L,u_in_phy)
pr_lp = getpress_p(dx,dt,1.0)
print 'pr_lp', pr_lp

deltaP = False
FFT = False
outletBC = ['expol','dnt','eq','pab']

for outlet in range(len(outletBC)):
  outBC =  outletBC[outlet]
  if deltaP:
    plot.append(dict(kind = 'deltaP',data=[
                                           'inlet_ubb_outlet_'+outBC+'/lh2/nH50/tracking/2D_probe_density_p00001.res',
                                           'inlet_ubb_outlet_'+outBC+'/lh2/nH50/tracking/2D_probe_density_p00002.res'],
         row=[-2000,-1],col=[1,2,2],
         convertPhy = True, xfac = 1., yfac = pr_lp, label = outBC+' nH50 l/h=2'))
  
    plot.append(dict(kind = 'deltaP',data=[
                                           'inlet_ubb_outlet_'+outBC+'/lh3/nH50/tracking/2D_probe_density_p00000.res',
                                           'inlet_ubb_outlet_'+outBC+'/lh3/nH50/tracking/2D_probe_density_p00001.res'],
              row=[-2000,-1],col=[1,2,2],
              convertPhy = True, xfac = 1., yfac = pr_lp, label = 'l/h=3'))
    
    plot.append(dict(kind = 'deltaP',data=[
                                         'inlet_ubb_outlet_'+outBC+'/lh5/nH50/tracking/2D_probe_density_p00000.res',
                                         'inlet_ubb_outlet_'+outBC+'/lh5/nH50/tracking/2D_probe_density_p00000.res'],
            row=[-2000,-1],col=[1,2,3],
            convertPhy = True, xfac = 1., yfac = pr_lp, label = 'l/h=5'))
      
  ###nH100
    plot.append(dict(kind = 'deltaP',data=[
                                           'inlet_ubb_outlet_'+outBC+'/lh2/nH100/tracking/2D_probe_density_p00001.res',
                                           'inlet_ubb_outlet_'+outBC+'/lh2/nH100/tracking/2D_probe_density_p00001.res'],
              row=[-2000,-1],col=[1,2,3],
              convertPhy = True, xfac = 1., yfac = pr_lp, label = outBC+' nH100 l/h=2'))
    
    plot.append(dict(kind = 'deltaP',data=[
                                           'inlet_ubb_outlet_'+outBC+'/lh3/nH100/tracking/2D_probe_density_p00000.res',
                                           'inlet_ubb_outlet_'+outBC+'/lh3/nH100/tracking/2D_probe_density_p00000.res'],
              row=[-2000,-1],col=[1,2,3],
              convertPhy = True, xfac = 1., yfac = pr_lp, label = 'l/h=3'))
    
    plot.append(dict(kind = 'deltaP',data=[
                                           'inlet_ubb_outlet_'+outBC+'/lh5/nH100/tracking/2D_probe_density_p00000.res',
                                           'inlet_ubb_outlet_'+outBC+'/lh5/nH100/tracking/2D_probe_density_p00000.res'],
              row=[-2000,-1],col=[1,2,3],
              convertPhy = True, xfac = 1., yfac = pr_lp, label = 'l/h=5'))
    ##nH150
    plot.append(dict(kind = 'deltaP',data=[
                                           'inlet_ubb_outlet_'+outBC+'/lh2/nH150/tracking/2D_probe_density_p00001.res',
                                           'inlet_ubb_outlet_'+outBC+'/lh2/nH150/tracking/2D_probe_density_p00002.res'],
              row=[-2000,-1],col=[1,2,2],
              convertPhy = True, xfac = 1., yfac = pr_lp, label = outBC+' nH150 l/h=2'))
    
    plot.append(dict(kind = 'deltaP',data=[
                                           'inlet_ubb_outlet_'+outBC+'/lh3/nH150/tracking/2D_probe_density_p00001.res',
                                           'inlet_ubb_outlet_'+outBC+'/lh3/nH150/tracking/2D_probe_density_p00001.res'],
              row=[-2000,-1],col=[1,2,3],
              convertPhy = True, xfac = 1., yfac = pr_lp, label = 'l/h=3'))
    
    plot.append(dict(kind = 'deltaP',data=[
                                           'inlet_ubb_outlet_'+outBC+'/lh5/nH150/tracking/2D_probe_density_p00000.res',
                                           'inlet_ubb_outlet_'+outBC+'/lh5/nH150/tracking/2D_probe_density_p00000.res'],
              row=[-2000,-1],col=[1,2,3],
              convertPhy = True, xfac = 1., yfac = pr_lp, label = 'l/h=5'))
    ##nH200
    plot.append(dict(kind = 'deltaP',data=[
                                           'inlet_ubb_outlet_'+outBC+'/lh2/nH200/tracking/2D_probe_density_p00001.res',
                                           'inlet_ubb_outlet_'+outBC+'/lh2/nH200/tracking/2D_probe_density_p00001.res'],
              row=[-2000,-1],col=[1,2,3],
              convertPhy = True, xfac = 1., yfac = pr_lp, label = outBC+' nH200 l/h=2'))
    
    plot.append(dict(kind = 'deltaP',data=[
                                           'inlet_ubb_outlet_'+outBC+'/lh3/nH200/tracking/2D_probe_density_p00000.res',
                                           'inlet_ubb_outlet_'+outBC+'/lh3/nH200/tracking/2D_probe_density_p00000.res'],
              row=[-2000,-1],col=[1,2,3],
              convertPhy = True, xfac = 1., yfac = pr_lp, label = 'l/h=3'))
    
    plot.append(dict(kind = 'deltaP',data=[
                                           'inlet_ubb_outlet_'+outBC+'/lh5/nH200/tracking/2D_probe_density_p00000.res',
                                           'inlet_ubb_outlet_'+outBC+'/lh5/nH200/tracking/2D_probe_density_p00000.res'],
              row=[-2000,-1],col=[1,2,3],
              convertPhy = True, xfac = 1., yfac = pr_lp, label = 'l/h=5'))
    ##nH300
    plot.append(dict(kind = 'deltaP',data=[
                                           'inlet_ubb_outlet_'+outBC+'/lh2/nH300/tracking/2D_probe_density_p00001.res',
                                           'inlet_ubb_outlet_'+outBC+'/lh2/nH300/tracking/2D_probe_density_p00002.res'],
              row=[-2000,-1],col=[1,2,2],
              convertPhy = True, xfac = 1., yfac = pr_lp, label = outBC+' nH300 l/h=2'))
    
    plot.append(dict(kind = 'deltaP',data=[
                                           'inlet_ubb_outlet_'+outBC+'/lh3/nH300/tracking/2D_probe_density_p00001.res',
                                           'inlet_ubb_outlet_'+outBC+'/lh3/nH300/tracking/2D_probe_density_p00001.res'],
              row=[-2000,-1],col=[1,2,3],
              convertPhy = True, xfac = 1., yfac = pr_lp, label = 'l/h=3'))
    
    plot.append(dict(kind = 'deltaP',data=[
                                           'inlet_ubb_outlet_'+outBC+'/lh5/nH300/tracking/2D_probe_density_p00000.res',
                                           'inlet_ubb_outlet_'+outBC+'/lh5/nH300/tracking/2D_probe_density_p00000.res'],
              row=[-2000,-1],col=[1,2,3],
              convertPhy = True, xfac = 1., yfac = pr_lp, label = 'l/h=5'))
    
    ##nH400
    plot.append(dict(kind = 'deltaP',data=[
                                           'inlet_ubb_outlet_'+outBC+'/lh2/nH400/tracking/2D_probe_density_p00001.res',
                                           'inlet_ubb_outlet_'+outBC+'/lh2/nH400/tracking/2D_probe_density_p00001.res'],
              row=[-2000,-1],col=[1,2,3],
              convertPhy = True, xfac = 1., yfac = pr_lp, label = outBC+' nH400 l/h=2'))
    
    plot.append(dict(kind = 'deltaP',data=[
                                           'inlet_ubb_outlet_'+outBC+'/lh3/nH400/tracking/2D_probe_density_p00000.res',
                                           'inlet_ubb_outlet_'+outBC+'/lh3/nH400/tracking/2D_probe_density_p00000.res'],
              row=[-2000,-1],col=[1,2,3],
              convertPhy = True, xfac = 1., yfac = pr_lp, label = 'l/h=3'))
    
    plot.append(dict(kind = 'deltaP',data=[
                                           'inlet_ubb_outlet_'+outBC+'/lh5/nH400/tracking/2D_probe_density_p00000.res',
                                           'inlet_ubb_outlet_'+outBC+'/lh5/nH400/tracking/2D_probe_density_p00000.res'],
              row=[-2000,-1],col=[1,2,3],
              convertPhy = True, xfac = 1., yfac = pr_lp, label = 'l/h=5'))

  nHeight = 50
  dx = getdxFromnL(height,nHeight)
  dt = getdt_acoustic(dx,u_in_L,u_in_phy)
  if FFT:
#nH50  
    plot.append(dict(kind = 'FFT',data=[   'inlet_ubb_outlet_'+outBC+'/lh2/nH50/tracking/2D_probe_velocity_p00002.res'],
         row=[-2048,-1],col=[1,3],
         convertPhy = True, xfac = dt, yfac = dx/dt, label = outBC+' nH50 l/h=2'))

    plot.append(dict(kind = 'FFT',data=[   'inlet_ubb_outlet_'+outBC+'/lh3/nH50/tracking/2D_probe_velocity_p00001.res'],
         row=[-2048,-1],col=[1,3],
         convertPhy = True, xfac = dt, yfac = dx/dt, label = outBC+' nH50 l/h=3'))

    plot.append(dict(kind = 'FFT',data=[   'inlet_ubb_outlet_'+outBC+'/lh5/nH50/tracking/2D_probe_velocity_p00000.res'],
         row=[-2048,-1],col=[1,6],
         convertPhy = True, xfac = dt, yfac = dx/dt, label = outBC+' nH50 l/h=5'))
#nH100         
    nHeight = 100
    dx = getdxFromnL(height,nHeight)
    dt = getdt_acoustic(dx,u_in_L,u_in_phy)
    plot.append(dict(kind = 'FFT',data=[   'inlet_ubb_outlet_'+outBC+'/lh2/nH100/tracking/2D_probe_velocity_p00002.res'],
         row=[-2048,-1],col=[1,3],
         convertPhy = True, xfac = dt, yfac = dx/dt, label = outBC+' nH100   l/h=2'))

    plot.append(dict(kind = 'FFT',data=[   'inlet_ubb_outlet_'+outBC+'/lh3/nH100/tracking/2D_probe_velocity_p00001.res'],
         row=[-2048,-1],col=[1,3],
         convertPhy = True, xfac = dt, yfac = dx/dt, label = outBC+' nH100   l/h=3'))

    plot.append(dict(kind = 'FFT',data=[   'inlet_ubb_outlet_'+outBC+'/lh5/nH100/tracking/2D_probe_velocity_p00001.res'],
         row=[-2048,-1],col=[1,3],
         convertPhy = True, xfac = dt, yfac = dx/dt, label = outBC+' nH100   l/h=5'))
#nH150    
    nHeight = 150
    dx = getdxFromnL(height,nHeight)
    dt = getdt_acoustic(dx,u_in_L,u_in_phy)
    plot.append(dict(kind = 'FFT',data=[   'inlet_ubb_outlet_'+outBC+'/lh2/nH150/tracking/2D_probe_velocity_p00004.res'],
         row=[-2048,-1],col=[1,3],
         convertPhy = True, xfac = dt, yfac = dx/dt, label = outBC+' nH150   l/h=2'))

    plot.append(dict(kind = 'FFT',data=[   'inlet_ubb_outlet_'+outBC+'/lh3/nH150/tracking/2D_probe_velocity_p00002.res'],
         row=[-2048,-1],col=[1,3],
         convertPhy = True, xfac = dt, yfac = dx/dt, label = outBC+' nH150   l/h=3'))

    plot.append(dict(kind = 'FFT',data=[   'inlet_ubb_outlet_'+outBC+'/lh5/nH150/tracking/2D_probe_velocity_p00001.res'],
         row=[-2048,-1],col=[1,3],
         convertPhy = True, xfac = dt, yfac = dx/dt, label = outBC+' nH150   l/h=5'))
#nH200    
    nHeight = 200
    dx = getdxFromnL(height,nHeight)
    dt = getdt_acoustic(dx,u_in_L,u_in_phy)
    plot.append(dict(kind = 'FFT',data=[   'inlet_ubb_outlet_'+outBC+'/lh2/nH200/tracking/2D_probe_velocity_p00002.res'],
         row=[-2048,-1],col=[1,3],
         convertPhy = True, xfac = dt, yfac = dx/dt, label = outBC+' nH200   l/h=2'))

    plot.append(dict(kind = 'FFT',data=[   'inlet_ubb_outlet_'+outBC+'/lh3/nH200/tracking/2D_probe_velocity_p00001.res'],
         row=[-2048,-1],col=[1,3],
         convertPhy = True, xfac = dt, yfac = dx/dt, label = outBC+' nH200   l/h=3'))

    plot.append(dict(kind = 'FFT',data=[   'inlet_ubb_outlet_'+outBC+'/lh5/nH200/tracking/2D_probe_velocity_p00001.res'],
         row=[-2048,-1],col=[1,3],
         convertPhy = True, xfac = dt, yfac = dx/dt, label = outBC+' nH200   l/h=5'))
#nH300    
    nHeight = 300
    dx = getdxFromnL(height,nHeight)
    dt = getdt_acoustic(dx,u_in_L,u_in_phy)
    plot.append(dict(kind = 'FFT',data=[   'inlet_ubb_outlet_'+outBC+'/lh2/nH300/tracking/2D_probe_velocity_p00004.res'],
         row=[-2048,-1],col=[1,3],
         convertPhy = True, xfac = dt, yfac = dx/dt, label = outBC+' nH300   l/h=2'))

    plot.append(dict(kind = 'FFT',data=[   'inlet_ubb_outlet_'+outBC+'/lh3/nH300/tracking/2D_probe_velocity_p00002.res'],
         row=[-2048,-1],col=[1,3],
         convertPhy = True, xfac = dt, yfac = dx/dt, label = outBC+' nH300   l/h=3'))

    plot.append(dict(kind = 'FFT',data=[   'inlet_ubb_outlet_'+outBC+'/lh5/nH300/tracking/2D_probe_velocity_p00001.res'],
         row=[-2048,-1],col=[1,3],
         convertPhy = True, xfac = dt, yfac = dx/dt, label = outBC+' nH300   l/h=5'))
#nH400    
    nHeight = 400
    dx = getdxFromnL(height,nHeight)
    dt = getdt_acoustic(dx,u_in_L,u_in_phy)
    plot.append(dict(kind = 'FFT',data=[   'inlet_ubb_outlet_'+outBC+'/lh2/nH400/tracking/2D_probe_velocity_p00002.res'],
         row=[-2048,-1],col=[1,3],
         convertPhy = True, xfac = dt, yfac = dx/dt, label = outBC+' nH400   l/h=2'))

    plot.append(dict(kind = 'FFT',data=[   'inlet_ubb_outlet_'+outBC+'/lh3/nH400/tracking/2D_probe_velocity_p00001.res'],
         row=[-2048,-1],col=[1,3],
         convertPhy = True, xfac = dt, yfac = dx/dt, label = outBC+' nH400   l/h=3'))

    plot.append(dict(kind = 'FFT',data=[   'inlet_ubb_outlet_'+outBC+'/lh5/nH400/tracking/2D_probe_velocity_p00001.res'],
         row=[-2048,-1],col=[1,3],
         convertPhy = True, xfac = dt, yfac = dx/dt, label = outBC+' nH400   l/h=5'))


#plot.append(dict(kind = 'xy',data=[   'inlet_ubb_outlet_expol/lh5/nH150/tracking/2D_probe_velocity_p00001.res'],
#     row=[-2048,-1],col=[1,3],
#     convertPhy = True, xfac = dt, yfac = dx/dt, label = ' nH150   l/h=5'))
#
#
#
#
#
#plot.append(dict(kind = 'FFT',data=['Re100/inlet_ubb_outlet_eq/lh2/nH150/tracking/2D_probe_velocity_p00002.res'],
#           row=[-512,-1],col=[1,3],
#           convertPhy = True, xfac = dt, yfac = dx/dt))


## xy plot
#plot.append(dict(kind = 'xy',data=['inlet_ubb_outlet_expol/lh5/level9/tracking/2D_line_p00000_t00000050.000E+03.res',
#                                   'inlet_ubb_outlet_expol/lh3/level9/tracking/2D_line_p00000_t00000050.000E+03.res'],
#           row=[1,-1],col=[1,6],
#           convertPhy = True, xfac = 1.0, yfac = u_lp))
