import math

def getdxFromnL(length,nLength):
  return float(length)/nLength

def getdxFromLevel(length,level):
  return float(length)/math.pow(2,level)

def getdt_acoustic(dx,u_l,u_p):
  return dx*u_l/u_p
  
def getdt_diffusive(dx,omega,nu_p):
  return ((1.0/omega - 0.5)/3.0)*math.pow(dx,2)/nu_p

def getpress_p(dx,dt,rho0):
  return rho0*math.pow(dx/dt,2.0)/3.0
