import os
apesFolder = os.getenv('HOME')+'/apes/'
# Production directory - default production directory is 'prod'
# comment out if you don't want user defined production directory
prod_dir = 'prod'
loglevel = 'INFO'
shepherd_jobs = []

shepherd_jobs.append(dict(executable=apesFolder+'seeder/build/seeder',
                          template='seeder.template',
                          extension='lua',
                          run_exec = True,
                          run_command = '',
                          params = [['l_h',5],
                                    ['nHeight',50]
                                   ] ,
                          additional_params = dict(MESH='mesh/'),
                          create_subdir = ['mesh'],
                          prefix = 'sdr',
                          label = 'seeder'))

shepherd_jobs.append(dict(executable=apesFolder+'musubi/build/musubi',
                          template='musubi.template',
                          extension='lua',
                          run_exec = True,
                          run_command = 'mpirun -np 8',
                          params = [[ "Re", 100 ],['kind','lbm']],
                          #additional_params = dict(MESH='../mesh/',kind='lbm_incomp'),
                          additional_params = dict(MESH='../mesh/'),
                          create_subdir = ['tracking','restart'],
                          prefix = 'mus_new',
                          depend = ['seeder'],
                          create_depend_path = True,
                          label = 'musubi_new'))

shepherd_jobs.append(dict(executable=apesFolder+'harvester/scripts/harvest_series.py',
                          template = 'params_hvs.py',
                          extension = 'py',
                          run_exec = True,
                          run_command = '',
                          input_option = '--config',
                          depend = ['musubi_new'],
                          #run_last = True,
                          #create_depend_path = True,
                          #create_depend_params = True,#["musubi_phase_shift","musubi_theta_eq"],
                          label = 'hvs'))

#shepherd_jobs.append(dict(executable=os.getenv('HOME')+'/apes_default/musubi/build/musubi',
#                          template='musubi.template',
#                          extension='lua',
#                          run_exec = True,
#                          run_command = 'mpirun -np 4',
#                          params = [[ "Re", 500 ]],
#                          additional_params = dict(MESH='../mesh/',kind='lbm'),
#                          create_subdir = ['tracking','restart'],
#                          prefix = 'mus_old',
#                          depend = ['seeder'],
#                          create_depend_path = True,
#                          label = 'musubi_old'))
#
#shepherd_jobs.append(dict(executable=apesFolder+'harvester/scripts/harvest_series.py',
#                          template = 'params_hvs.py',
#                          extension = 'py',
#                          run_exec = True,
#                          run_command = '',
#                          input_option = '--config',
#                          depend = ['musubi_old'],
#                          #run_last = True,
#                          #create_depend_path = True,
#                          #create_depend_params = True,#["musubi_phase_shift","musubi_theta_eq"],
#                          label = 'hvs'))


