-- this file include common parameters used by both seeder and musubi
-- the 2d channel has a height of 1m, and length of 4m
-- physical density is 1050 kg/m^3
-- dynamic viscosity is 3.5E-6

printRuntimeInfo = false
mesh = 'mesh/'

height = 0.01
length = height * 4    -- physical length of channel

level = 8   -- mesh refine level
dx = length / 2.^level
ly = height / dx       -- number of elements for channel height
lx = length / dx - 2   -- number of elements for channel height
R = height / 2    -- channel radius

denPhy = 1050
viscPhy = 0.0000035      -- dynamic viscosity
Re = 100     -- Re = vel * height / visc
velMeanPhy = Re * viscPhy / height
velMaxPhy = velMeanPhy * 3 / 2
pGradPhy = velMaxPhy * 2 * viscPhy / denPhy  -- pressure gradient
pDeltaPhy = pGradPhy * length
pDeltaPhy = 12 * viscPhy * denPhy * velMeanPhy * (length) / height / height
periodPhy = 0.8
angFreqPhy = 2 * math.pi / periodPhy
Wo = R * math.sqrt( angFreqPhy / viscPhy )   -- Womersley number

-- reference LB quantities
tmax  = 400000
omega = 1.95
viscLB = ( 1.0 / omega - 0.5 ) / 3.0   -- viscosity LB
dt = viscLB / viscPhy * dx * dx

rho0 = 1.
cs2  = 1./3.
p0   = rho0*cs2
p0Phy = p0 * denPhy * dx * dx / dt / dt

-- Analytical solutions
function wssA(x, y, z, t)
  return viscPhy * denPhy * 2 * math.abs(y) * velMaxPhy / R / R
end
function velA(x, y, z, t)
  return velMaxPhy * ( 1 - (y)^2 / R^2 )
end
