import os
apesFolder = os.getenv('HOME')+'/apes_default/'
# Production directory - default production directory is 'prod'
# comment out if you don't want user defined production directory
prod_dir = 'prod'
######################################################################################
shepherd_jobs = []

shepherd_jobs.append(dict(executable=apesFolder+'musubi/build/musubi',
                     template='musubi.template',
                     # use this input file for multispecies performance
                     #template='musubi_MS.template',
                     extension='lua',
                     run_exec = False,
                     run_command = '',
                     params = [
                              ["cpat","isend_irecv"]
                              ],
                     create_dir = True,
                     prefix = 'mus',
                     label = 'musubi'))

shepherd_jobs.append(dict(executable=None,
                     template='cray.template',
                     extension='pbs',
                     run_exec = True,
                     run_command = 'qsub',
                     params = [
                              [( "nProcs","nodes", "run_time"),
                                ( 32,     1,        "00:30:00"),
                                ( 2*32,   2,        "00:20:00")],
                              ],
                     additional_params = dict(name='gausspulse', 
                                              ProcPerNode=32, 
                                              level="3 4 5"),
                     create_dir = False,
                     create_depend_path = True,
                     depend = ['musubi'],
                     label = 'cray'))
######################################################################################

