require 'common'

-- boundingbox: two entries: origin and length in this
-- order, if no keys are used
bounding_cube = {origin = x0, length = length}

spatial_object = {
  {
    attribute = {
      kind = 'refinement',
      level = refinementLevel+level,
      label='box1'
    },
    geometry = {
      kind = 'canoND',
      object = {
        origin = {start_x, start_y, start_z },
        vec = {{size_x, 0., 0.},
              {0.,size_y, 0.},
              {0., 0., size_z}}
      }
    }
  },

  { attribute = { kind = 'seed', },
    geometry = { 
      kind = 'canoND',
      object = { origin = { x0[1]+length*0.5, x0[2]+dx*1.5, x0[3]+dx*1.5 } }
    } -- geometry
  }, -- seed
} -- spatial objects

if usePeriodic == true then
  -- periodic Z planes
  table.insert(spatial_object, {
    attribute = {
      kind = 'periodic',
      label = 'periodic'
    },
    geometry = {
      kind = 'periodic',
      object = {
        plane1 = {
          origin = { x0[1], x0[2], periodic_z1},
          vec = { { length, 0.0, 0.0},
                  { 0.0, length, 0.0},}
        }, -- plane 1
        plane2 = {
          origin = { x0[1], x0[2], periodic_z2},
          vec = { { 0., length, 0.0},
                  { length, 0., 0.0},}
        }, -- plane 2
      } -- object
    } -- geometry
  }) -- table insert
end
if use2ndPeriodic then
  table.insert(spatial_object, { 
    attribute = { 
      kind = 'periodic', 
      label = 'periodic'
    },
    geometry = {
      kind = 'periodic',
      object = {
        plane1 = {
          origin = { x0[1], x0[2]+2.*dx+dxDash, x0[3]},
          vec = { 
                  { 0.0, 0.0, length},{ length, 0.0, 0.0},}
        }, -- plane 1
        plane2 = {
          origin = { x0[1], x0[2]+dx-dxDash, x0[3]},
          vec = { 
                  { length, 0., 0.0},{ 0., 0.0 , length},}
        }, -- plane 2
      } -- object
    } -- geometry

  }) 
end

