import os
apesFolder = os.getenv('HOME')+'/apes/'
# Production directory - default production directory is 'prod'
# comment out if you don't want user defined production directory
scaling = 'diffusive'
prod_dir = 'prod'

# empty job list
shepherd_jobs = []

# seeder job
shepherd_jobs.append(dict(
                     # path to executable if available or set to None
                     executable=apesFolder+'seeder/build/seeder',
                     # path to template file to generate input for exectuable
                     # using pyratemplate
                     template='seeder.template',
                     # extension of input file
                     extension='lua',
                     # to run executable
                     run_exec = True,
                     # command line option to run exectuable
                     # example: run_command='mpirun -np 4'
                     run_command = '',
                     # command line option for exectuable used between
                     # exectuable and input file
                     input_option = '',
                     # exit shepherd if run job fails
                     # default is False
                     abort_failure = True,
                     # parameters to be changed in template file
                     # which are also used to create dirpath 
                     # or filenames if create_dir = False
                     params = [['level',2,3],['ref',4]],
                     # additional params to be changed in template file
                     # not used to create dirpath or filenames.
                     # Must be a dictorary
                     additional_params = dict(MESH='mesh/'),
                     # create dirpath for each paramter set defined
                     # in params list. default is True
                     create_dir = True,
                     # list of subdirectories to create for this job
                     create_subdir = ['mesh'],
                     # prefix to dirpath or filename
                     prefix = 'SEEDER',
                     # identifier to this job used by dependend jobs
                     # to create dependend job params and path
                     label = 'seeder'))

# musubi job
shepherd_jobs.append(dict(executable=apesFolder+'musubi/build/musubi',
                     # path to template file to generate input for exectuable
                     # using pyratemplate
                     template='musubi.template',
                     # extension of input file
                     extension='lua',
                     run_exec = True,
                     # exit shepherd if run job fails
                     # default is False
                     abort_failure = True,
                     run_command = '',
                     params = [["Re", 50 ],
                               ["scaling", scaling],
                               ["model", 'bgk'],
                               ["intp", 'quadratic'],
                               ["om", 1.9]
                              ],
                     additional_params = dict(MESH='../mesh/'),
                     create_subdir = ['tracking','restart'],
                     prefix = 'MUSUBI',
                     # list of dependent jobs
                     depend = ['seeder'],
                     # to use depend job path in this job template file
                     # default is False
                     create_depend_path = True,
                     # to use depend job params in this job template file.
                     # default is False
                     create_depend_params = True,
                     label = 'musubi'))

#
#jobscript_template = 'quelea.template'
#submit_job = False
#sub_command = 'sbatch'
#job_params = [  [ ( "NPROCS"  ),
#                  (  "8" )],
#                [ "NP_NODE",
#                   4
#                ]
#             ]
#
#harvester_template = 'harvester.template'
#path_to_harvester_exec = '../../../../harvester/build/harvester'
