#/opt/local/bin/zsh

export LEVEL=7

mkdir mesh
mkdir tracking
mkdir output
mkdir pictures
rm mesh/*
rm tracking/*
rm output/*
rm pictures/*

export musubi_log='./runMusubi.log'
export seeder_log='./runSeeder.log'

export probe_file=tracking/probe_temporal.res

export probe_p_pic=pictures/probe_p_temporal.eps
export probe_vel_pic=pictures/probe_vel_temporal.eps
export probe_s_pic=pictures/probe_s_temporal.eps

$seeder | tee ${seeder_log}
$musubi | tee ${musubi_log}
lua print_params.lua >> ${musubi_log}
lua print_params.lua
# $harvester

# collect results
cat tracking/*probe*res >> $probe_file

# plot results
gnuplot plot.gpl

