-- This file contains important parameters
--
if os.getenv('LEVEL') == nil or os.getenv('LEVEL') == "" then
  level = 5
else
  level = tonumber( os.getenv('LEVEL'))
end
refinementLevel = 0
minLevel = level
minlevel = minLevel
maxLevel = level+refinementLevel

usePeriodic = true
use2ndPeriodic = false
halfhalf = false
useObstacle = false

-- some constant parameters
sqrt3 = math.sqrt(3.0)
twoPi = 2.0 * math.pi

-- flow domain [0, 2*pi]
length = twoPi
dx     = length / (2^level)
dxMin  = length / (2^maxLevel)
dxDash = 0.5*dxMin

-- Use this file as template. Do not modify this file for running some testcases
outputname = 'channel_2D'
outputpreview = true
folder = 'mesh/' --mesh_l'..level..'_'..refinementLevel..'/'
ebug = {debugMode = true, debugFiles = true, debugMesh = 'debug/'}

x0 = {0., 0., 0.}      -- bounding box origin

-- refinement box
size_x  = 0.001*length - 2.*dxDash
start_x = length*0.5 - 0.5*size_x + x0[1]
size_y  = size_x
start_y = start_x
if usePeriodic then
  size_z = length
  start_z = x0[3]
  periodic_z1 = x0[3] + 2.*dx + dxDash
  periodic_z2 = x0[3] + dx - dxDash
else
  size_z = length --size_y
  start_z = x0[3] --start_y
end
if halfhalf then
  start_x = x0[1]
  start_y = x0[2]
  start_z = x0[3]
  size_x = 0.5*length-2.*dxDash
  size_y = length
  size_z = length
end

---------------------------------------------------------------------
-- Simulation setup
-- General test case geometry and setup settings
if usePeriodic then
  dimension = 2
  kernelDim = 2
else
  dimension = 3
 kernelDim = 3
end
Re = 25

refinement = refinementLevel
periodic = usePeriodic
testing = false
studyError = false
--intp = 'quadratic'
intp = 'linear'
--scaling = 'diffusive'
scaling = 'acoustic'
relaxation = 'mrt'
--model = 'lbm_incomp'
model = 'lbm'
-- random fluctuation
randFluc = 0.00
