----------------------- PLEASE READ THIS ---------------------------!!!

-- This input file is set up to run for regression check
-- Please make sure you DO NOT MODIFY AND PUSH it to the repository

--------------------------------------------------------------------!!!


-- Musubi configuration file. 
-- This is a LUA script.

-- Simulation name
simulation_name = 'simple_channel'
mesh = 'mesh/' -- Mesh information
logging = {level=3}
printRuntimeInfo = false

-- Time step settigs
tmax = 2000     -- total iteration number
sim_control = {
  time_control = {
    max = {iter=tmax},
    interval = { iter = tmax },
  },
}

model = 'lbm'
rho0 = 1.
cs2 = 1./3.
p0 = 0
fluid = { omega = 1.891 }
identify = { kind = model }

interpolation_method = 'linear'

-- Initial condition
initial_condition = {
  pressure  = p0,
  velocityX = 0.0,
  velocityY = 0.0,
  velocityZ = 0.0,
}

-- Boundary conditions
boundary_condition = {
{ label = 'west',
  kind = 'inlet_ubb',
  velocity = 'inlet_velocity'},
{ label = 'east',
  kind = 'outlet_expol',
  pressure = 'outlet_pressure',}, 
{ label = 'north', 
   kind = 'wall' },
{ label = 'south', 
   kind = 'wall' },
{ label = 'top', 
   kind = 'wall' },
{ label = 'bottom', 
   kind = 'wall' }
}

variable = {
  {
    name = 'vel_x',
    ncomponents = 1,
    vartype = 'st_fun',
    st_fun = {
      predefined = 'combined',
      temporal = { 
        predefined='smooth', 
        min_factor = 0.0, max_factor=0.08, 
        from_time=0, to_time=tmax/2
      }, 
      spatial = {
        predefined='parabol',
        shape = {
          kind = 'canoND',
          object = {
            center  = {-8.0,0.0,0.0},
            halfvec = { {0.0,1.0,0.0}, {0.0,0.0,1.0}}
          },
        },
        amplitude = 1.0
      }
    }
  },
  {
    name = 'vel_y',
    ncomponents = 1,
    vartype = 'st_fun',
    st_fun = 0.0
  },
  { name = 'vel_z',
    ncomponents = 1,
    vartype = 'st_fun',
    st_fun = 0.0
  },
  {
    name = 'inlet_velocity',
    ncomponents = 3,
    vartype = 'operation',
    operation = {
      kind = 'combine',
      input_varname = {'vel_x','vel_y','vel_z'}
    }
  },
  {
    name = 'outlet_pressure',
    ncomponents = 1,
    vartype='st_fun',
    st_fun = p0
  }
}

-- Tracking
tracking = {
  label = 'probe_density',
  variable = {'density'},
  folder = 'tracking/',
  shape = {
    kind = 'canoND',
    object = {
      origin ={0.0,0.,0.},
    },
  },
  time_control = {min = {iter=0}, max = {iter=tmax}, interval = {iter=tmax/10}},
  output = { format = 'ascii' },
}
