-- common header --
level =  6  
refinementLevel = 1
length = 1.

dimension = 2
if dimension == 2 then
  usePeriodic = true
else
  usePeriodic = false
end
use2ndPeriodic = false
halfhalf = false
useObstacle = false

--
maxLevel = level+refinementLevel

dx     = length/(2^level)
dxMin  = length/(2^maxLevel)
dxDash = 0.5*dxMin
-- Use this file as template. Do not modify this file for running some testcases
outputname = 'channel_2D'
outputpreview = true
folder = 'mesh/' --mesh_l'..level..'_'..refinementLevel..'/' 

-- general refinement levels
-- minrefine: defines minimum refinement level of the entire domain
--
-- maxrefine: defines maximum refinement
-- gets overwritten from madatory STL levels
-- will become default for stl refinement level once
-- it is not mandatory any more
minlevel  = level
-- stl_files: for each stl file put a table into
-- this table of tables. Or just a string for
-- the filname, if the other two parameters should
-- get the default: boundary_type = 1, fileformat = 'binary'
-- refinementlevel is the level to which the stl shall be refined
-- it is mandatory

seederLength = length
x0 = {0.,0., 0.}
--x0 = {-length*0.25,-length*0.25, -length*0.25}
ebug = {debugMode = true, debugFiles = true, debugMesh = 'debug/'}
size_x = 0.5*length - 2.*dxDash
start_x = length*0.5-0.5*size_x + x0[1]
size_y = size_x
start_y =start_x
if usePeriodic then
  size_z = seederLength
  start_z = x0[3]
else
  size_z = length --size_y
  start_z = x0[3] --start_y
end
if halfhalf then
  start_x = x0[1]
  start_y = x0[2]
  start_z = x0[3]
  size_x = 0.5*length-2.*dxDash
  size_y = length
  size_z = length
end 

-- boundingbox: two entries: origin and length in this
-- order, if no keys are used
bounding_cube = {origin = x0,
               length = length}

spatial_object = {
  {
    attribute = {
      kind = 'refinement',
      level = refinementLevel+level,
      label='box1'
    },
    geometry = {
      kind = 'canoND',
      object = {
        origin = {start_x, start_y, start_z },
        vec = {{size_x, 0., 0.},
              {0.,size_y, 0.},
              {0., 0., size_z}}
      }
    }
  },

  { attribute = { kind = 'seed', },
    geometry = { kind = 'canoND',
                 object = { origin = { x0[1]+length*0.5, x0[2]+dx*1.5, x0[3]+dx*1.5 },
               }
    } -- geometry
  }, -- seed

}

if usePeriodic == true then
  table.insert(spatial_object, { 
    attribute = { 
      kind = 'periodic', 
      label = 'periodic'
    },
    geometry = {
      kind = 'periodic',
      object = {
        plane1 = {
          origin = { x0[1], x0[2], x0[3]+2.*dx+dxDash},
          vec = { { length, 0.0, 0.0},
                  { 0.0, length, 0.0},}
        }, -- plane 1
        plane2 = {
          origin = { x0[1], x0[2], x0[3]+dx-dxDash},
          vec = { { 0., length, 0.0},
                  { length, 0., 0.0},}
        }, -- plane 2
      } -- object
    } -- geometry

  }) 
if use2ndPeriodic then
  table.insert(spatial_object, { 
    attribute = { 
      kind = 'periodic', 
      label = 'periodic'
    },
    geometry = {
      kind = 'periodic',
      object = {
        plane1 = {
          origin = { x0[1], x0[2]+2.*dx+dxDash, x0[3]},
          vec = { 
                  { 0.0, 0.0, length},{ length, 0.0, 0.0},}
        }, -- plane 1
        plane2 = {
          origin = { x0[1], x0[2]+dx-dxDash, x0[3]},
          vec = { 
                  { length, 0., 0.0},{ 0., 0.0 , length},}
        }, -- plane 2
      } -- object
    } -- geometry

  }) 
end
end

