-- Musubi configuration file. 
require "common" 
scaling = 'acoustic'

TopBottomBC = 'outlet_nrbc'
outletBC = 'outlet_expol'

if usePeriodic then
  dp = 1
else
  dp = 10
end
Re = 100
Re = 500
-- physical reference quantities
u0 = 1.
viscosity = u0*height/Re
rho0 = 1.
-- LB reference quantities
cs2LB=1./3.
rho0LB = 1.
p0LB = rho0LB*cs2LB
u0LB=0.05
omega0=1.9
relaxation = 'mrt_les'

if scaling == 'acoustic' then
  uLB=u0LB
  dt = uLB/u0*dx
  viscLB = viscosity*dt/dx/dx
  omega = 1./(3.*viscLB + 0.5)
else
  omega = omega0
  viscLB  = 1./6.*(2./omega - 1.)
  dt = viscLB/viscosity*dx*dx  
  uLB=u0*dt/dx
end 

if model == 'lbm_incomp' then
  p0 = 0.
else
  p0 = p0LB*rho0*dx*dx/dt/dt
end 
pIn = p0 + dp

-- Simulation name
simulation_name = 'channel2D'
mesh = 'mesh_channel/'
printRuntimeInfo = false
-- Time step settigs
tEnd  =  10.  
tRamp = tEnd/20
time  = { useIterations = false, max = tEnd, interval = tEnd/10}

debug = { checkNans = true }
ebug = { debugMode = true, debugFiles = true, debugNormal = true,
          debugMesh = './debug/mesh_', debugStates = { 
  write = {
    folder    = './debug/',  -- the folder the restart files are written to
    interval  = 1,           -- dump restart file interval
    tmin      = 1,           -- first timestep to output
    tEnd      = tEnd+1       -- last timestep to output
    }
 }} 



fluid = { omega = omega, rho0 = rho0LB }

interpolation_method = 'linear'                     

-- Initial condition 
initial_condition = { pressure  = p0, 
                      velocityX = 0.0,
                      velocityY = 0.0,
                      velocityZ = 0.0 }

identify = {label='channel',layout='d3q19', relaxation=relaxation,
            kind = 'lbm_incomp'
            }

-- needed to dump variable in physical unit
physics = { dt = dt, rho0 = rho0 }            
-- Boundary conditions
boundary_condition = {  
{ label = 'west', 
   kind = 'outlet_expol',
  pressure = --pressureIn,
    { kind = 'combined',
      transient= {predefined='smooth', min_factor = p0, 
                  max_factor=pIn, from_time=0, to_time=tRamp}, 
      spatial = pressureIn,
   },
--  kind = 'inlet_ubb', 
--  velocityX = { kind = 'combined',
--                transient= {predefined='smooth', min_factor = 0.0, 
--                            max_factor=u0, from_time=0, to_time=tRamp}, 
--                spatial = {predefined='parabol', 
--                          shape = { kind = 'canoND', object = {center  = {0.0,height*0.5,zpos},
--                                                               halfvec = {0.0,height*0.5,0.0} } 
--                                  }
--                          ,amplitude = 1.0 
--                         } },         
   velocityY = 0.0, velocityZ = 0.0},
{ label = 'east',
   kind = outletBC,
   pressure  =  p0}, 
{ label = 'north', 
   kind = TopBottomBC, pressure = p0, L = nHeight,
   fac = 1.0 },
{ label = 'south', 
   kind = TopBottomBC, pressure = p0, L = nHeight}
 }
if obstacle then
  table.insert( boundary_condition, 
  { label = 'sphere', kind= 'wall' } 
  )
end
if outflow then
  table.insert( boundary_condition, 
  { label = 'backplate', kind= 'wall' } 
  )
  table.insert( boundary_condition, 
  { label = 'northOutflow', kind= 'wall' } 
  )
  table.insert( boundary_condition, 
  { label = 'southOutflow', kind= 'wall' } 
  )
end
if not usePeriodic then
  table.insert( boundary_condition, 
  { label = 'top', kind= TopBottomBC, pressure = p0, L = nHeight } 
  )
  table.insert( boundary_condition, 
  { label = 'bottom', kind= TopBottomBC, pressure = p0, L = nHeight } 
  )
  if outflow then
  table.insert( boundary_condition, 
  { label = 'topOutflow', kind= 'wall' } 
  )
  table.insert( boundary_condition, 
  { label = 'bottomOutflow', kind= 'wall' } 
  )
end 
end



-- Tracking              
tracking = {
{
  label = 'probe', 
  folder = 'tracking/',
 variable = {'pressure_phy'}, 
 shape = {kind = 'canoND', object = {origin ={0.,height*0.,zpos} } },
 time = {useIterations = true, max = tEnd/dt, interval = 1},
  format = 'ascii'      
},
-- {
--   label = 'line', 
--   folder = 'tracking/',
--  variable = {{'pressure'},{'velocity'},{'pressure_phy'},{'velocity_phy'}}, 
--  shape = {kind = 'canoND', object = {origin ={0.0,height*0.5,zpos},
--                                      vec = {length,0.0,0.0},
--                                      segments = nLength+2} },
--  time = {max = tEnd, interval = tEnd/10},
--   format = 'asciiSpatial'      
-- },
-- 
-- {
--   label = 'probe_velocity', 
--   folder = 'tracking/',
--  variable = {'velocity'}, 
--  shape = {kind = 'canoND', object = {origin = {dx+dx/2,height*0.5,zpos}} },
--  time = {max = tEnd, interval = tEnd/10.},
--   format = 'ascii'      
-- },
{
  label = 'hvs', 
  folder = 'tracking/',
 variable = {{'pressure_phy'},{'velocity_phy'},{'treeID'}}, 
 --shape = {kind = 'canoND', object = {origin ={0.0,height*0.5,zpos},vec={length,height*0.5,zpos }} },
 shape = {kind = 'all' },
 time = {max = tEnd, interval = tEnd/10, min = 0},
  format = 'harvester'      
}
}

estart = {
      ead = 'restart/channel2D_lastHeader.lua',
      write = 'restart/',
      time = { min = tEnd, max = tEnd, interval = tEnd}
 }
