-- Musubi configuration file. 
-- This is a LUA script.
require 'common'
tracking_fol = 'tracking/'
restart_fol = 'restart/'

dx = getdxFromLevel( {len_bnd=length_bnd, level=level})
dt = getdtFromVel( {dx = dx, u_p = u_max_phy, u_l = u_max_L } )
omega = getOmegaFromdt( {dx=dx, dt=dt, nu_p = nu_phy } )

if qVal then 
  bc_nozzle = 'wall_linearInterpolation'
else
  bc_nozzle = 'wall'
end

-- Simulation name
simulation_name = 'nozzle'
-- Mesh information
mesh = 'mesh/'

-- Time step settings
tmax_p = 3 --s
tmax           =  tmax_p/dt     -- total iteration number
interval = 1000
sim_control = {
  time_control = {
    max = {sim=tmax_p}, 
    interval = {iter=interval}},
  bort_criteria = {
    steady_state = true
  }
}    

-- needed to dump variable in physical unit
physics = { dt = dt, rho0 = rho0_p }            

-- physics setting
fluid = { 
        omega_ramping = {predefined='smooth', min_factor = 0.5, max_factor=1.0, 
        from_time=0, to_time=1}, 
       omega = omega, 
       rho0 = rho0_p }

interpolation_method = 'quadratic'
--control_routine = 'fast'
scaling = 'diffusive'
                     
-- Initial condition 
initial_condition = { pressure = p0_p, 
                      velocityX = u_mean_phy*0.5,
                      velocityY = 0.0,
                      velocityZ = 0.0 }


identify = {label='2D',layout='d3q19',relaxation='mrt', kind = 'lbm_incomp'}


-- Boundary conditions
boundary_condition = {  
 { label = 'inlet', 
   kind = 'inlet_ubb', 
--   order = 1,
  velocityX = { predefined = 'combined',
              transient= {predefined='smooth', min_factor = 0.5, max_factor=1.0, 
              from_time=0, to_time=1}, 
              spatial = u_mean_phy--u_inflow 
	      },
   --velocityX = 0.01, 
   velocityY = 0.0, velocityZ = 0.0 }
,{ label = 'outlet', 
   kind = 'outlet_expol',
   pressure = p0_p}
,{ label = 'nozzle', 
   kind = bc_nozzle}
}

variable = {
  {
    name = 'ref_pressure',
    ncomponents = 1,
    vartype = 'st_fun',
    st_fun = p0_p
  },
  {
    name = 'normalized_pressure',
    ncomponents = 1,
    vartype = 'operation',
    operation = { 
      kind = 'difference',
      input_varname = {'pressure_phy','ref_pressure'}
    }
  }  
}
          
--tracking time_control
trac_time = {min = 0, max= tmax_p, interval = {iter=100}}

-- Tracking              
tracking = {
{
  label = 'hvs', 
  folder = tracking_fol,
  variable = {'normalized_pressure','velocity_phy','shear_stress_phy','velocity'}, 
  shape = {kind = 'all' },
  time_control = {min = tmax_p, max={sim=tmax_p,clock=walltime}, interval=tmax_p},
  format = 'harvester'      
},

{ label = 'convergence',
  variable = {'normalized_pressure'}, 
  shape = {kind = 'canoND', object= {origin = {0.0,0.0,0.0}}},
  time_control = {min = 0, max = tmax_p, interval = {iter=10}},
  format='convergence',
  convergence = {norm='average', nvals = 50, absolute = true,
  condition = { threshold = 1.e-8, operator = '<=' }}
}
,{label='hline',
    folder=tracking_fol,
    variable={'normalized_pressure','velocity_phy'},
    shape = {kind='canoND', object={origin={-inlet_2_nozzleCenter,0.0,dx_c_half},
                                    vec={{l_ch,0.0,0.0}},
             segments = {nLength}}},
    time_control = {min = tmax_p, max={sim=tmax_p,clock=walltime}, interval=tmax_p},
    format = 'asciiSpatial'}
,{label='vline',
    folder=tracking_fol,
    variable={'normalized_pressure','velocity_phy'},
    shape = {kind='canoND', object={origin={nozzle_inner_dia_X,-inner_rad_nozzle,dx_c_half},
                                    vec={{inner_dia_nozzle,0.0,0.0}},
             segments = {inner_dia_nozzle/dx_refine}}},
    time_control = {min = tmax_p, max={sim=tmax_p,clock=walltime}, interval=tmax_p},
    format = 'asciiSpatial'}
 ,{label='probe_nozzle_inner',
    folder=tracking_fol,
    variable={'normalized_pressure','velocity_phy'},
    shape = {kind='canoND', 
             object={origin={nozzle_inner_dia_X,0.0,dx_c_half}}},
    time_control = trac_time,
    format = 'ascii'}
,{label='probe_nozzle_outlet',
    folder=tracking_fol,
    variable={'normalized_pressure','velocity_phy'},
    shape = {kind='canoND', 
             object={origin={outlet_2_nozzleCenter/2.0,0.0,dx_c_half}}},
    time_control = trac_time,
    format = 'ascii'}
,{label='probe_nozzle_center',
    folder=tracking_fol,
    variable={'normalized_pressure','velocity_phy'},
    shape = {kind='canoND', 
             object={origin={0.0,0.0,dx_c_half}}},
    time_control = trac_time,
    format = 'ascii'}

}

-- restart 
restart = {
      ead = restart_fol..'/nozzle_lastHeader.lua',
      write = restart_fol,
      time_control = { min = tmax_p}
}



