----------------------- PLEASE READ THIS ---------------------------!!!

-- This input file is set up to run for regression check
-- Please make sure you DO NOT MODIFY AND PUSH it to the repository

--------------------------------------------------------------------!!!


-- Musubi configuration file. 
-- This is a LUA script.

-- Simulation name
simulation_name = 'mini-channel'
mesh            = 'mesh/'  -- Mesh information
printRuntimeInfo = false
-- Time step settings
tmax           = 5000  -- total iteration number
period         = 0.1
interval       = tmax/10
probe_interval = 500
trackstart     = 0
sim_control    = {
  time_control = {
    max      = {iter=tmax},
    interval = {iter=interval}
  }
}

logging = { level = 5 }
dump_bc_timing = false

ebug = {
  verbosity    = 100,
  debugMode    = true,
  debugFiles   = true,
  dumpTreeIDs  = true,
  dumpAuxLists = true,
  -- debugMesh    = './debug/mesh_',
  -- debugStates  = {
  --   write = {
  --     folder    = './debug/',    -- the folder the restart files are written to
  --     time_control = { useIterations = true,interval = 1, min = 1, max = tmax }
  --   },
  -- },
  logging = { level = 5, root_only = false, filename = 'dbg', },
}

-- Initial condition
rho0 = 1.
cs2  = 1./3.
initial_condition = {
  pressure  = 0.0,
  velocityX = 0.0, velocityY = 0.0, velocityZ = 0.0,
  Sxx = 0, Syy = 0, Szz = 0, Sxy = 0, Syz = 0, Sxz = 0,
}

-- Boundary conditions
boundary_condition = {
  { label = 'inlet',  kind = 'inlet_ubb', velocity  = 'inlet_vel' },
  { label = 'wall',   kind = 'wall' },
  { label = 'outlet', kind = 'outlet_expol', pressure  = 'p0' },
}

-- user variables
variable = {
  {
    name = 'inlet_vel',
    ncomponents = 3,
    vartype = 'st_fun',
    st_fun = {0.06,0.0,0.0}
  },
  {
    name = 'p0',
    ncomponents = 1,
    vartype = 'st_fun',
    st_fun = 0.0
  },
}
--
fluid = { omega = 1.8 }
identify = {
    kind       = 'lbm',
    layout     = 'd3q19',
    relaxation = 'bgk',
}

-- Tracking
tracking = {
  -- This track is used by recheck!
  { label = 'probePress', 
    variable = {'density'}, 
    shape= { kind = 'canoND', object={origin ={0., 0., 0.} } },
    time_control = { min = {iter=0}, max = {iter=tmax}, interval = {iter=20}},
    output={format = 'ascii'}
  },
  { label = 'velocityProfile',
    variable = {'velocity'},
    shape= {
      kind = 'canoND',
      object = {
        origin = {  0., -20., 0.},
        vec = {  0.,40.,0.},
        segments = 4,
      }
    },
    time_control = { min = {iter=tmax}}, -- dump at last timestep
    -- folder = 'tracking/',
    output={format = 'asciiSpatial'}
  },
  { label = 'pressureDrop',
    variable = {'density'}, 
    shape= {
      kind = 'canoND',
      object={
        origin ={-75., 0., 0.},
        vec = {150.,0.,0.}, 
        segments=100
      }
    },
    time_control = { min = {iter=tmax}},
    -- folder = 'tracking/',
    output={format = 'asciiSpatial'}
  },
  { label = 'totalDens', 
    variable = {'density'}, 
    reduction = {'sum'}, 
    shape= { kind = 'all' },
    time_control = { min = {iter=0}, max = {iter=tmax}, interval = {iter=1}},
    -- folder = 'tracking/',
    output={format = 'ascii'}
  },
   ----plane in the middle of the channel:
   --{ label    = 'plane_velocity', 
   --  variable = { 'velocity' }, 
   --  shape    = {
   --    kind   = 'canoND',
   --    object = {
   --      origin       = { 0., -10 , -10 }, 
   --      vec          = { {0.0,20.,0.}, {0.,0.0,20} },
   --      segments     = { 100, 500},
   --        distribution = 'equal',
   --      }
   --    },
   --  folder       = 'tracking/',
   --  output={format       = 'harvester'}, 
   --  time_control = { 
   --    min      = { iter = trackstart     }, 
   --    max      = { iter = tmax           }, 
   --    interval = { iter = probe_interval } 
   --  },

   --},
}

-- Restart settings
estart = {
  -- If this table is available it will write a restart file
  -- with the specified options.
  write        = 'restart/', -- the folder the restart files are written to
  time_control = {min = {iter=tmax}}
}
