-- Location to write the mesh in.
-- Note the trailing path seperator, needed, if all mesh files should be in a
-- directory. This directory has to exist before running Seeder in this case!
folder = 'mesh/'

-- Bounding cube: the root node of the octree, defining the complete universe,
-- from which all elements are derived by recursive bisection.
-- The origin is the corner from which on the cube is spanned with the given
-- length in each direction.
bounding_cube = {origin = {-0.5, -0.5, -0.5},
               length = 1.0}


-- A minimum level, by which all parts in the computational domain should at
-- least be resolved with. Default is 0.
minlevel = 5

-- *********************** Table of spatial objects *********************** --
-- Each spatial object is defined by an attribute and some geometric entity
-- attached to this attribute. Attributes might be defined multiple times.
-- Attributes are described by a kind (boundary, seed or refinement), a level
-- and maybe further kind specific values, like a label for the boundary.
-- Geometric objects might by right now:
-- - canoND (point, line, plane or box)
-- - STL
spatial_object = {
  {
    attribute = {
      kind = 'boundary',
      label='movingwall'
    },
    geometry = {
      kind = 'stl',
      object = {
        filename = 'stl/Lidcavity_movingwall.stl'
      }
    }
  },
  {
    attribute = {
      kind = 'boundary',
      label='fixedwall'
    },
    geometry = {
      kind = 'stl',
      object = {
        filename = 'stl/Lidcavity_fixedwall.stl'
      }
    }
  },
  {
    attribute = {
      kind = 'seed',
    },
    geometry = {
      kind = 'canoND',
      object = {
        origin = {0.,0.,0.}
      }
    }
  }
}
