require "params"
-- Musubi configuration file. 
-- This is a LUA script.
originX_1 = 5.0
originX_2 = 32.0
originY = 32.0
originZ = 32.0
halfwidth = 3.0
amplitude = 0.001
background = 1.0

simulation_name = 'crvp'
mesh = 'mesh_${refinement}$/'

function ic_1Dgauss_pulse(x, y, z)
  return background+amplitude*math.exp(-0.5/(halfwidth^2)*( x - originX_1 )^2)
end
function ic_2Dgauss_pulse(x, y, z)
  return background+amplitude*math.exp(-0.5/(halfwidth^2)*(( x - originX_2 )^2+( y - originY )^2))
end

-- Time step settigs
time = {useIterations = true, min = 1, max = 100, interval = 1}
check_interval =  1

interpolation_method = '${interpolation_method}$'

scheme = {

  initial_condition = {
                        density = ${initial_condition}$,
                        velocityX = 0.0,
                        velocityY = 0.0,
                        velocityZ = 0.0 },

  debug = { debugMode = true, debugFiles = true,
            debugMesh = './debug/mesh_debug', debugStates = { 
    write = {
      folder    = 'debug/',
      interval  = 1,
      tmin      = 1,
      tmax      = 1
      }
   }},
  
  fluid = {omega = 1.8, rho0 = 1.0 },
  
  boundary_condition = {  
  { label = 'periodic_Z',
     kind = 'periodic' }
  },
  
                       
  output = { active = false, -- VTK output activated?
    folder = 'output/',     -- Output location
    vtk = true,             -- VTK output activated?
    time = {min = 0, max=1, interval=40 }
  },
}

if '${refinement}$' == 'local' then
  scheme.fluid.omega = 1.8
else
  scheme.fluid.omega = 1.63636363636364
end

-- Tracking
if '${initial_condition}$' == 'ic_1Dgauss_pulse' then
  scheme.tracking = {
    { label = 'lineX_${interpolation_method}$_${refinement}$',
      variable = {{'density'}},
      shape= {{object='line', line ={ origin = {0.,32.,32.}, direction = {64.,0.,0.}, segments=200 }}},
      format='asciiSpatial', folder='tracking/', 
      time = {interval = 1, min = 0, max = -1}
    }
  } 
else
  scheme.tracking = {
    { label = 'pointX_${interpolation_method}$_${refinement}$', 
      variable = {'density'}, 
      shape = {{object='point', point ={32.+24.0,32.,32.}}}, -- 24 in pos. x direction from center
      time = {interval = 1, min = 0, max = -1},
      format='ascii', folder='tracking/'
    },
    { label = 'pointDiag_${interpolation_method}$_${refinement}$', 
      variable = {'density'}, 
      shape = {{object='point', point ={32.+17.,32.+17.,32.}}}, -- sqrt(2*17^2) = 24.042 in diag from center
      time = {interval = 1, min = 0, max = -1},
      format='ascii', folder='tracking/'
    },
    { label = 'plane_${interpolation_method}$_${refinement}$',
      variable = {'density'},
      shape = {{object='plane', plane ={
        pos = {0.,0.,32.},
        vecA = { 32., 0., 0.},
        vecB = { 0., 32., 0.},
        segments1=600,
        segments2=600
        }}},
      format='harvester', folder='tracking/',
      time = {interval = 1, min = 0, max = -1}
    }
  } 
end


