require "params"

-- Musubi configuration file. 
-- This is a LUA script.
originX_1 = length/8.0
originX_2 = 0.
originY = .0
originZ = .0
halfwidth = pulse_size
amplitude = 0.0001
background = 1.0

simulation_name = 'crvp'
mesh = 'mesh/'

debug = {debugMode = true, debugFiles = true}

function ic_1Dgauss_pulse(x, y, z, t)
  return background+amplitude*math.exp(-0.5/(halfwidth^2)*( x - originX_1 )^2)
end
function ic_2Dgauss_pulse(x, y, z, t)
  return background+amplitude*math.exp(-0.5/(halfwidth^2)*(( x - originX_2 )^2+( y - originY )^2))
end

-- Time step settigs
sim_control = {
  time_control = {
    max = {iter= tmax},
      interval = {iter= tmax/10}
      }
   }
check_interval = 1
interpolation_method = 'average'

scheme = {
  initial_condition = {
                        pressure = ic_1Dgauss_pulse,
                        velocityX = 0.0,
                        velocityY = 0.0,
                        velocityZ = 0.0 },

  ebug = { debugMode = true, debugFiles = true,
            debugMesh = './debug/mesh_debug', debugStates = { 
    write = {
      folder    = 'debug/',
      interval  = 1,
      tmin      = 1,
      tmax      = 1
      }
   }},
  
  fluid = {omega = global_omega, rho0 = 1.0 },
  
}

scheme.tracking = {
    { label = 'lineX_'..interpolation_method..'_l'..level,
      variable = {'pressure'},
      shape= { kind = 'canoND', object = {origin = {originX,0.,dx*0.5}, 
                                          vec = {length,0.,0.}, 
                                          segments=10*2^maxlevel }
             },
      output = {format='asciiSpatial'}, 
      folder='tracking/', 
      time_control = {interval={iter=tmax/100}, min={iter= 0}, max ={iter= tmax}
    }
  } 
}
