require "common"

simulation_name = 'nozzle'
timing_file = 'sdr_timing.res'
-- Location to write the mesh in.
-- Note the trailing path seperator, needed, if all mesh files should be in a
-- directory. This directory has to exist before running Seeder in this case!
folder = 'mesh/'

logging = {level=10}
ebug = {debugMode = true, debugFiles = false, debugMesh='debug/' }

-- bounding cube: two entries: origin and length in this
-- order, if no keys are used
bounding_cube = {origin = origin_boundCube,
                length = length_bnd}

-- minimum refinement level in fluid domain
minlevel = level

spatial_object = {
  {
    attribute = {
      kind = 'seed',
      label='seed'
    },
    geometry = {
      kind = 'canoND',
      object = {
        origin = { origin_inletBC[1]+dx, 0.0, dx_c_half },
        vec = { l_ch-dx, 0.0,0.0}
      }
    }
  },
  -- First refinement box closer to nozzle
  {
    attribute = {
      kind = 'refinement',
      level=refineLevel
    },
    geometry = {
      kind = 'canoND',
      object = {
        origin = {-l_nozzle/2.0-offset_refine, -outer_rad_nozzle-offset_refine, -outer_rad_nozzle-offset_refine},
        vec = { {l_nozzle+2*offset_refine,0.0,0.0},
                {0.0, outer_dia_nozzle+2*offset_refine, 0.0},
                {0.0, 0.0, outer_dia_nozzle+2*offset_refine } }
      }
    }
  },
  {
    -- Defining a domain boundary
    attribute = {
      kind = 'boundary', -- or seed, refinement
      label = 'nozzle',   -- some label to identify the boundary condition
      level = nozzleLevel,
      calc_dist = qVal,
      distance_refine = {
        {
          radius = inner_dia_nozzle*2,
          level_offset = 0
        },
        {
          radius = inner_dia_nozzle*3,
          level_offset = -1
        },
        {
          radius = inner_dia_nozzle*4,
          level_offset = -2
        }
      }
    },
    geometry = {
      kind = 'canoND',
      object = {
        -- Upper triangle
        -- plane 1
        { origin = { -l_nozzle/2.0, outer_rad_nozzle, -nozzle_zPos},
          vec = { {l_nozzle/2.0-math.abs(nozzle_inner_dia_X), -(outer_rad_nozzle-inner_rad_nozzle), 0.0},
                  {0.0, 0.0, 2*nozzle_zPos}}
        },          
        -- plane 2
        { origin = { -l_nozzle/2.0, outer_rad_nozzle, -nozzle_zPos},
          vec = { {l_nozzle, 0.0, 0.0},
                  {0.0, 0.0, 2*nozzle_zPos}}
        },          
        -- plane 3
        { origin = { nozzle_inner_dia_X, inner_rad_nozzle, -nozzle_zPos},
          vec = { {l_nozzle/2.0+math.abs(nozzle_inner_dia_X), outer_rad_nozzle-inner_rad_nozzle, 0.0},
                  {0.0, 0.0, 2*nozzle_zPos}}
        },          
        -- Lower triangle
        -- plane 1
        { origin = { -l_nozzle/2.0, -outer_rad_nozzle, -nozzle_zPos},
          vec = { {l_nozzle/2.0-math.abs(nozzle_inner_dia_X), outer_rad_nozzle-inner_rad_nozzle, 0.0},
                  {0.0, 0.0, 2*nozzle_zPos}}
        },          
        -- plane 2
        { origin = { -l_nozzle/2.0, -outer_rad_nozzle, -nozzle_zPos},
          vec = { {l_nozzle, 0.0, 0.0},
                  {0.0, 0.0, 2*nozzle_zPos}}
        },          
        -- plane 3
        { origin = { nozzle_inner_dia_X, -inner_rad_nozzle, -nozzle_zPos},
          vec = { {l_nozzle/2.0+math.abs(nozzle_inner_dia_X), -(outer_rad_nozzle-inner_rad_nozzle), 0.0},
                  {0.0, 0.0, 2*nozzle_zPos}}
        },          
      }
    }
  },

  {
    attribute = {
      kind = 'boundary',
      label = 'inlet',
      level = level
    },
    geometry = {
      kind = 'canoND',
      object = {
        origin = origin_inletBC, 
        vec = { {0.0,h_ch+2*dx,0.0},
                {0.0,0.0,h_ch+2*dx}}
      }
    }
  },
  {
    attribute = {
      kind = 'boundary',
      label = 'outlet',
      level = level
    },
    geometry = {
      kind = 'canoND',
      object = {
        {
          origin = origin_outletBC,
          vec = { {0.0,h_ch+2*dx,0.0},
                  {0.0,0.0,h_ch+2*dx}}
        },
      }
    }
  },  
  {
    attribute = {
      kind = 'boundary',
      label = 'outlet',
      level = level
    },
    geometry = {
      kind = 'canoND',
      object = {
        {
          origin = origin_inletBC,
          vec = { {l_ch+2*dx_eps,0.0,0.0},
                  {0.0,0.0,h_ch+2*dx_eps}}
        },          
        {
          origin = {origin_inletBC[1], h_ch/2.0+dx_eps, origin_inletBC[3]},
          vec = { {l_ch+2*dx_eps,0.0,0.0},
                  {0.0,0.0,h_ch+2*dx_eps}}
        },       
      }
    }
  },
  {
    -- Defining a periodic
    attribute = {
      kind = 'periodic',
      level = level
    },
    geometry = {
      kind = 'periodic',
      object = {
        plane1 = {
          origin = {origin_inletBC[1]+dx_c_half+dx_eps, -h_ch/2.0+dx_eps, dx+dx_eps },
          vec = { {l_ch-2*dx_eps, 0.0, 0.0},
                  {0.0, h_ch-2*dx_eps, 0.0}}
        },
        plane2 = {
          origin = {origin_inletBC[1]+dx_c_half+dx_eps, -h_ch/2.0+dx_eps, -dx_eps },
          vec = { {0.0, h_ch-2*dx_eps, 0.0},
                  {l_ch-2*dx_eps, 0.0, 0.0}}
        }
      }   
    }  
  },
}
