-- Musubi configuration file. 
-- This is a LUA script.
require 'common'
tracking_fol = 'tracking/'
vtk_fol = 'vtkfiles/'
restart_fol = 'restart/'

-- Musubi lua functions to get dx, dt and omega
--dx = getdxFromLevel( {len_bnd=length_bnd, level=level})
--dt = getdtFromVel( {dx = dx, u_p = u_max_phy, u_l = u_max_L } )
--omega = getOmegaFromdt( {dx=dx, dt=dt, nu_p = nu_phy } )

if qVal then 
  bc_nozzle = 'wall_linearInterpolation'
else
  bc_nozzle = 'wall'
end

-- Simulation name
simulation_name = 'nozzle'
logging = {level=5}
timing_file = 'mus_timing.res'
-- Mesh information
mesh = 'mesh/'
-- general settings
printRuntimeInfo = false

-- Time step settings
wallclock = 30*60 - 3*60
tmax_p = 5.0 --s
tmax           =  tmax_p/dt     -- total iteration number
interval = 1000
sim_control = {
  time_control = {
    max = {sim=tmax_p,clock=wallclock}, 
    interval = {iter=interval}
  },
  abort_criteria = {
    steady_state = true,
    convergence = {
      variable = {'normalized_pressure', 'velocity_phy'}, 
      shape = {kind = 'canoND', object= {origin = {0.0,0.0,0.0}}},
      time_control = {min = 1.0, max = tmax_p, interval = 10*dt},
      reduction = {'average', 'average'},
      norm='average', nvals = 50, absolute = true,
      condition = { 
        {threshold = 1.e-8, operator = '<=' },
        {threshold = 1.e-8, operator = '<=' }
      }
    }
  }
}    

-- needed to dump variable in physical unit
physics = { dt = dt, rho0 = rho0_p }            

-- physics setting
fluid = { 
       omega = omega
}

interpolation_method = 'quadratic'
--control_routine = 'fast'
--scaling = 'diffusive'
scaling = 'acoustic'
                     
-- Initial condition 
initial_condition = { pressure = p0_p, 
                      velocityX = 0.0, 
                      velocityY = 0.0,
                      velocityZ = 0.0 }


identify = {label='2D',layout='d2q9',relaxation='mrt', kind = 'lbm_incomp'}


-- Boundary conditions
boundary_condition = {  
  { label = 'inlet', 
    kind = 'inlet_ubb', 
    velocity = { 
      predefined = 'combined',
      temporal = {
        predefined ='smooth', 
        min_factor = 0.0, 
        max_factor = 1.0, 
        from_time = 0, 
        to_time=0.25
      }, 
      spatial = {u_mean_phy,0.0,0.0} 
    },
  },
  { label = 'outlet', 
    kind = 'outlet_expol',
    pressure = p0_p,
    curved = true
  },
--  { label = 'outlet_NS', 
--    kind = 'outlet_expol',
--    pressure = p0_p
--  },
  { label = 'nozzle', 
    kind = bc_nozzle
  }
}

variable = {
  {
    name = 'ref_pressure',
    ncomponents = 1,
    vartype = 'st_fun',
    st_fun = p0_p
  },
  {
    name = 'normalized_pressure',
    ncomponents = 1,
    vartype = 'operation',
    operation = { 
      kind = 'difference',
      input_varname = {'pressure_phy','ref_pressure'}
    }
  },
  {
    name = 'cs_inv',
    ncomponents = 1,
    vartype = 'st_fun',
    st_fun = cs_inv
  },
  {
    name = 'mach_nr',
    ncomponents = 1,
    vartype = 'operation',
    operation = {
      kind = 'multiplication',
      input_varname = {'vel_mag', 'cs_inv'},
    }  
  }
}
          
--tracking time_control
trac_time = {min = 0, max= tmax_p, interval = {iter=100}}

-- Tracking              
tracking = {
--  {
--    label = 'vtk', 
--    folder = vtk_fol,
--    variable = {'normalized_pressure',
--                'velocity_phy',
--                'shear_stress_phy',
--                'velocity',
--                'mach_nr'
--    }, 
--    shape = {kind = 'all' },
--    time_control = {
--      min = 0, 
--      max={sim=tmax_p,clock=walltime}, 
--      interval=0.05,
--    },
--    output = {format = 'vtk'}
--  },
--  {
--    label='hline',
--    folder=tracking_fol,
--    variable={'normalized_pressure','velocity_phy'},
--    shape = {
--      kind='canoND', 
--      object={
--        origin={-inlet_2_nozzleCenter,0.0,dx_c_half},
--        vec={l_ch,0.0,0.0},
--        segments = nLength
--      }
--    },
--    --time_control = {min = tmax_p, max={sim=tmax_p,clock=walltime}, interval=tmax_p},
--    time_control = {min = 0.0, max={sim=tmax_p,clock=walltime}, interval=0.05},
--    output = {format = 'asciiSpatial'}
--  },
--  {
--    label='vline',
--    folder=tracking_fol,
--    variable={'normalized_pressure','velocity_phy'},
--    shape = {
--      kind='canoND', 
--      object={
--        origin={nozzle_inner_dia_X,-inner_rad_nozzle,dx_c_half},
--        vec={inner_dia_nozzle,0.0,0.0},
--        segments = inner_dia_nozzle/dx_refine
--      }
--    },
--    time_control = {min = tmax_p, max={sim=tmax_p,clock=walltime}, interval=tmax_p},
--    output = {format = 'asciiSpatial'}
--  },
  {
    label='probe_neck',
    folder=tracking_fol,
    variable={'normalized_pressure','velocity_phy'},
    shape = {
      kind='canoND', 
      object={
        origin={nozzle_inner_dia_X,0.0,dx_c_half}
      }
    },
    time_control = trac_time,
    output = {format = 'ascii'}
  },
--  {
--    label='probe_inlet',
--    folder=tracking_fol,
--    variable={'normalized_pressure','velocity_phy'},
--    shape = {
--      kind='canoND', 
--      object={
--        origin={-inlet_2_nozzleCenter+dx_c_half,0.0,dx_c_half}
--      }
--    },
--    time_control = trac_time,
--    output = {format = 'ascii'}
--  },
--  {
--    label='probe_outlet',
--    folder=tracking_fol,
--    variable={'normalized_pressure','velocity_phy'},
--    shape = {
--      kind='canoND', 
--      object={
--        origin={outlet_2_nozzleCenter/2.0,0.0,dx_c_half}
--      }
--    },
--    time_control = trac_time,
--    output = {format = 'ascii'}
--  },
--  {
--    label='probe_center',
--    folder=tracking_fol,
--    variable={'normalized_pressure','velocity_phy'},
--    shape = {
--      kind='canoND', 
--      object={
--        origin={0.0,0.0,dx_c_half}
--      }
--    },
--    time_control = trac_time,
--    output = {format = 'ascii'}
--  }
}

-- restart table
NOrestart = {
   --read = restart_fol..'/nozzle_lastHeader.lua',
   write = restart_fol,
   time_control = { min = tmax_p}
}
