--interpolation_method = 'quadraticCompact'
--interpolation_method = 'quadratic'
--interpolation_method = 'linear'
interpolation_method = 'average'
outputpreview = false

-- common header --
level =  6 
refinementLevel = 1  
label = 'channel'
idLabel = 'channel'
u_in = 0.02
-- geometry definition
length = 2.05
height =  3./16.*length
radius = 0.05
usePeriodic = false
useObstacle = true
useCylinder = true
cylOrientation = 'mini'
testIntersection = false

if useObstacle == true then
  refOmega = 1.98
  refLevel = 7
else
  refOmega = 1.9
  refLevel = 6
end
--
m = 2^(refLevel - level)
omega = 1./(1/m*(1/refOmega -0.5)+0.5)
maxLevel = level+refinementLevel

dx     = length/(2^level)
dxMin  = length/(2^maxLevel)
dxDash = 0.5*dxMin
viscLB = 1/3*(1/omega-1/2)
-- physical reference values
dxPhys = dx
lPhys = length  -- m
csPhys = 300    -- m/s
csLB = 1/math.sqrt(3)
--acoustic scaling with speeds of sound as reference
-- csPhys = csLB * dxPhys / dtPhys
dtPhys = csLB/csPhys*dxPhys
rho0 = 1  -- kg/m^3
viscPhys = viscLB*dxPhys^2/dtPhys


nElemsMax = 2^maxLevel
if useObstacle == true then
  nIters = nElemsMax*40
else
  nIters = nElemsMax*40
end
nIters = nElemsMax*40


-- Use this file as template. Do not modify this file for running some testcases
outputname = 'channel_2D'
folder = 'mesh/' 

-- general refinement levels
-- minrefine: defines minimum refinement level of the entire domain
--
-- maxrefine: defines maximum refinement
-- gets overwritten from madatory STL levels
-- will become default for stl refinement level once
-- it is not mandatory any more
minrefine = 1
maxrefine = level
-- stl_files: for each stl file put a table into
-- this table of tables. Or just a string for
-- the filname, if the other two parameters should
-- get the default: boundary_type = 1, fileformat = 'binary'
-- refinementlevel is the level to which the stl shall be refined
-- it is mandatory

seederLength = length+dx


size_x = 0.3*length
start_x = -0.15*length
if useObstacle then
  size_x = 0.63*length
  start_x = -0.42*length
  size_y = height/2-2.*dxDash
  if testIntersection then
    start_x = -0.35*length
  end
else
  size_y = height/3-2.*dxDash
end
start_y = -size_y/2
size_z = size_y
start_z = start_y
if useCylinder then
  if cylOrientation=='Y' then
    size_z  = size_y
    start_z = start_y
    size_y  = 3*size_y
    start_y = 3*start_y
  else
    size_z  = 3*size_y
    start_z = 3*start_y
  end
end

-- boundingbox: two entries: origin and length in this
-- order, if no keys are used
bounding_cube = {origin = {-seederLength*0.5, -seederLength*.5, -seederLength*0.5},
               length = seederLength}

    -- refinebox: three entries: origin, length and refinementlevel
    refinebox = {{origin = {-length*0.5, -height*.5, -0.5*height},
                length = {length, height, height},
                refinementlevel = level
                }
                }
    table.insert( refinebox, 
         {origin = {start_x, start_y, start_z }, 
          length = {size_x, size_y, size_z}, 
          refinementlevel = maxLevel
                  }) 
-- seed: position of seed 
seed = {0.0, 0.0, dx*0.5 }

geom={
     plane={
            {vecA={0.0,length,0.0},
              vecB={0.0,0.0,length},
              pos={length*0.5,-length*0.5,-length*0.5},
  	          bclabel='east',
  },
  {
    attribute = {
      kind = 'refinement',
      level = refinementlevel
    },
    geometry = {
      kind = 'canoND',
      object = {
        origin = {-length*0.5, -height*.5, -0.5*height},
                 length = {length, height, height},

      }
    }  
              }
            ,{vecA={0.0,length,0.0},
              vecB={0.0,0.0,length},
              pos={-length*0.5,-length*0.5,-length*0.5},
	            bclabel='west',
              }
             ,{vecA={length,0.0,0.0},
       	      vecB={0.0,0.0,length},
      	      pos={-length*0.5,height*0.5+dxDash,-length*0.5},
	            bclabel='north',
              }
             ,{vecA={length,0.0,0.0},
	            vecB={0.0,0.0,length},
      	      pos={-length*0.5,-height*0.5-dxDash,-length*0.5},
	            bclabel='south',
              }
             
             }
       }
if useObstacle ==true then
  if useCylinder == true then
    if cylOrientation =='Z' then
      stl_files  = {
              { filename = 'cylinder.stl', 
                bclabel = 'obs'},
      }
     elseif cylOrientation=='none' then
     elseif cylOrientation=='mini' then
      stl_files  = {
              { filename = 'cylinder_mini.stl', 
                bclabel = 'obs'},
      }
     else
      stl_files  = {
              { filename = 'cylinderY.stl', 
                bclabel = 'obs'},
      }
     end
  else
    geom[ 'sphere' ] = {{ pos = {-length*0.35,-0.01*height,0.},
              radius = radius,
              bclabel = 'obs'}}
  end
end

  if usePeriodic == true then
  else
    table.insert( geom.plane,
         {vecA={length,0.0,0.0},
       	      vecB={0.0,length,0.0},
      	      pos={-length*0.5,-length*0.5,height*0.5+dxDash},
	            bclabel='front',
              })
    table.insert(geom.plane, {vecA={length,0.0,0.0},
	            vecB={0.0,length,0.0},
      	      pos={-length*0.5,-length*0.5,-height*0.5-dxDash},
	            bclabel='back',
              })
  end

if usePeriodic ==true then
geom[ 'periodic' ] = {{
            plane1 = 
            {vecA={length,0.0,0.0},
             vecB={0.0,length,0.0},
             pos={-length*0.5,-length*0.5, dx+dxDash}},
            plane2 = 
            {vecB={length,0.0,0.0},
             vecA={0.0,length,0.0},
             pos={-length*0.5,-length*0.5,-dxDash}}
          }}
end

