require "seeder"

--require "PATH"
tracking_folder = './tracking/'--"TRACKING_FOLDER"
output_folder = './output/'--"OUTPUT_FOLDER"

-- Simulation name
mesh = './mesh/' -- Mesh information
ebug = {debugMode = true, debugFiles = true} --, dumpDependencies = true}
simulation_name = 'channelRefine'

identify = {label = idLabel, layout='d3q19'}
function ini_rho(x, y, z, t)
  return p0 - dp/length*x+dp*0.5
end

function ini_function(x, y, z, t)
  return (amplitude - amplitude*4/(height^2)*y^2)  --*(1.-0.2/length*x)
end

-- Time step settigs
tmax =   nIters    -- total iteration number
interval = tmax/30
tRamping = tmax/20
sim_control = {
  time_control = {
    max = {iter = tmax},
    interval = {iter=interval}
   }
 } 

fluid = { --#omega_ramping = { predefined='smooth', min_factor = 0.7, max_factor=1, from_time=0, to_time=tRamping}, 
       omega = omega, 
       rho0 = 1.0 }

-- Initial condition 
initial_condition = { pressure = 1.0, 
                      velocityX = 0.0, --ini_function,
                      velocityY = 0.0,
                      velocityZ = 0.0 }
-- Boundary conditions
boundary_condition = {  
{ label = 'east',
   kind = 'outlet_expol',
   pressure =  1.0}, 
{ label = 'north', 
   kind = 'wall' },
{ label = 'south', 
   kind = 'wall' },
 }

if usePeriodic ==false then
  table.insert( boundary_condition, 
{ label = 'front', 
   kind = 'wall' } )
  table.insert( boundary_condition, 
{ label = 'back', 
   kind = 'wall' } )
  table.insert( boundary_condition,{ label = 'west', 
  kind = 'inlet_ubb', 
  velocityX = { predefined = 'combined',
                transient= {
                  predefined='smooth', 
                  min_factor = 0.0, 
                  max_factor=1.0, 
                  from_time=0, 
                  to_time=tRamping}, 
                spatial = 
                 --u_in
                {
                  predefined='parabol', 
                  shape = { 
                    kind = 'canoND', 
                    object = {
                      center = {-0.5*length,0.,0.},
                      vec = { {0.0, height, 0.}, {0., 0., height}} 
                      } 
                   }
                  ,amplitude = u_in 
              }         
	      },
   velocityY = 0.0, velocityZ = 0.0} )else
  table.insert( boundary_condition,{ label = 'west', 
  kind = 'inlet_ubb', 
  velocityX = { predefined = 'combined',
                transient= {
                  predefined='smooth', 
                  min_factor = 0.0, 
                  max_factor=1.0, 
                  from_time=0, 
                  to_time=tRamping}, 
                spatial = u_in
--                {
--                  predefined='parabol', 
--                  shape = { 
--                    kind = 'canoND', 
--                    object = {
--                      origin = {-0.5*length, -(height-0.5*dx)*0.5, 0.0},
--                      vec = {0.0, height-0.5*dx, 0.0} 
--                      } 
--                   }
--                  ,amplitude = u_in 
--              }         
	      },
   velocityY = 0.0, velocityZ = 0.0} )
end
if useObstacle ==true then
  if cylOrientation ~= 'none' then
  table.insert( boundary_condition, 
{ label = 'obs', 
   kind = 'wall' } )
   end
 end

-- Tracking              
tracking = {
 {
 label = label..'_probePressure_l'..level, 
 variable = {'pressure'}, 
 shape = {kind = 'canoND', object = {origin ={0.0,0.,0.} } },
 time_control = {min = {iter= 1}, max = {iter= tmax}, interval = {iter= 5 }},
 format = 'ascii', folder = tracking_folder      
 }, 
 {
  -- tracking object for getting the error in terms of the l2norm
  label = label..'_hvsXZ_l'..level..interpolation_method, 
  variable = { 
     'pressure', 
     'velocity', 'wss'},
  shape = {kind = 'canoND', object = {origin ={ -length*0.5,0.,-height*0.5}, 
            vec={{length, 0., 0.}, {0.,0.,height}}, 
            segments = {2*nElemsMax, nElemsMax/2} } },     
  time_control = {min ={iter= tmax}, max ={iter= tmax}, interval ={iter=interval}},
  format = 'harvester',
  folder = tracking_folder
 }, 
 {
  -- tracking object for getting the error in terms of the l2norm
  label = label..'_hvsXY2_l'..level..interpolation_method, 
  variable = { 
     'pressure', 
     'velocity', 'wss'},
  shape = {kind = 'canoND', object = {origin ={ -length*0.5,-height*0.5,0.25*height}, 
            vec={{length, 0., 0.}, {0.,height,0.}}, 
            segments = {2*nElemsMax, nElemsMax/2} } },
  time_control = {min = {iter= tmax}, max = {iter= tmax}, interval = {iter= interval}},

  format = 'harvester',
  folder = tracking_folder
 },
{
  -- tracking object for getting the error in terms of the l2norm
  label = label..'_hvsYZ_l'..level, 
  variable = { 
     'pressure', 
     'velocity'},
  shape = {kind = 'canoND', object = {origin ={ -length*0.49,-height*0.5,-height*0.5}, 
            vec={{0., 0., height}, {0.,height,0.}}, 
            segments = {2*nElemsMax, nElemsMax/2} } },
  time_control = {min ={iter = tmax}, max ={iter = tmax}, interval = {iter = interval}},
  format = 'harvester',
  folder = tracking_folder
 }, 
{
  -- tracking object for getting the error in terms of the l2norm
  label = label..'_hvsXY_l'..level, --..interpolation_method, 
  variable = { 
     'pressure', 
     'velocity', 'wss'},
  shape = {kind = 'canoND', object = {origin ={ -length*0.5,-height*0.5,0.}, 
            vec={{length, 0., 0.}, {0.,height,0.}}, 
            segments = {2*nElemsMax, nElemsMax/2} } },
  time_control = {min = {iter = tmax}, max = {iter = tmax}, interval = {iter= interval}},
  format = 'harvester',
  folder = tracking_folder
 }, 
}
restart = {
       ead = 'restart/channelRefine_lastHeader.lua',
       write = 'restart/',
       time_control = { min = {iter= tmax }, interval={iter=tmax}
       }
    }

