import os
apesFolder = os.getenv('HOME')+'/apes/'
# Production directory - default production directory is 'prod'
# comment out if you don't want user defined production directory
prod_dir = 'omega_study'
run_seeder = True
run_musubi = True
run_gleaner = True

shepherd_jobs = []

shepherd_jobs.append(dict(executable=apesFolder+'seeder/build/seeder',
                          template='seeder.template',
                          extension='lua',
                          run_exec = run_seeder,
                          run_command = '',
                          params = [['nHeight',32],
                                    #['bc_type','moments','BounceBack']],
                                    #['bc_type','BounceBack']],
                                    ['bc_type','moments']],
                          additional_params = dict(MESH='mesh/'),
                          create_subdir = ['mesh'],
                          prefix = 'sdr',
                          label = 'seeder'))

shepherd_jobs.append(dict(executable=apesFolder+'musubi/build/musubi',
                          template='musubi.template',
                          extension='lua',
                          run_exec = run_musubi,
                          run_command = 'mpirun -np 4',
                          params = [["omega", 0.5, 0.7, 0.8, 0.9, 
                                     1.1, 1.2, 1.3, 1.4, 1.5
                                     ]
                                   ],
                          additional_params = dict(MESH='../mesh/'),
                          create_subdir = ['tracking','restart'],
                          prefix = 'mus',
                          depend = ['seeder'],
                          create_depend_path = True,
                          label = 'musubi'))

shepherd_jobs.append(dict(executable=apesFolder+'harvester/gleaner/gleaner.py',
                          template = 'params_plot_omega.py',
                          extension='py',
                          run_exec = run_gleaner,
                          run_command = '',
                          epend = ['seeder','musubi'],
                          depend = ['musubi'],
                          run_last = True,
                          create_depend_path = True,
                          create_depend_params = True,
                          label = 'gleaner'))

