import os
apesFolder = os.getenv('HOME')+'/apes/'
run_seeder=False
run_musubi=False
run_gleaner=True
# Production directory - default production directory is 'prod'
# comment out if you don't want user defined production directory
prod_dir = 'prod'

shepherd_jobs = []

shepherd_jobs.append(dict(executable=apesFolder+'seeder/build/seeder',
                          template='seeder.template',
                          extension='lua',
                          run_exec = run_seeder,
                          run_command = '',
                          #params = [['nHeight',16, 16*2, 16*4, 16*8 ],
                          #params = [['nHeight', 8, 8*2, 8*2**2, 8*2**3, 8*2**4  ],
                          params = [['nHeight', 8*2**1  ],
                                    #['bc_type','moments','BounceBack']],
                                    ['bc_type','BounceBack']],
                                    #['bc_type','moments']],
                          additional_params = dict(MESH='mesh/'),
                          create_subdir = ['mesh'],
                          prefix = 'sdr',
                          label = 'seeder'))

shepherd_jobs.append(dict(executable=apesFolder+'musubi/build/musubi',
                          template='musubi.template',
                          extension='lua',
                          run_exec = run_musubi,
                          run_command = 'mpirun -np 4',
                          params = [["omega", 1.3, 1.6, 1.9] 
                                   ],
                          additional_params = dict(MESH='../mesh/'),
                          create_subdir = ['tracking','restart'],
                          prefix = 'mus',
                          depend = ['seeder'],
                          create_depend_path = True,
                          label = 'musubi'))

shepherd_jobs.append(dict(executable=apesFolder+'harvester/gleaner/gleaner.py',
                          template = 'params_plot.py',
                          extension='py',
                          run_exec = run_gleaner,
                          run_command = '',
                          depend = ['seeder','musubi'],
                          #depend = ['musubi'],
                          run_last = True,
                          create_depend_path = True,
                          create_depend_params = True,
                          label = 'gleaner'))

#shepherd_jobs.append(dict(executable=apesFolder+'harvester/gleaner/gleaner.py',
#                          template = 'params_plot_error.py',
#                          extension='py',
#                          run_exec = True,
#                          run_command = '',
#                          depend = ['seeder','musubi'],
#                          #depend = ['musubi'],
#                          run_last = True,
#                          create_depend_path = True,
#                          create_depend_params = True,
#                          label = 'gleaner'))

