-- Use this file as template. Do not modify this file for running some testcases

require "common"

folder = 'mesh/'--..subprefix
ebug = {debugMode = true, debugFiles=true}

-- bounding_cube: two entries: origin and length in this
-- order, if no keys are used
bounding_cube = {origin = {-dx/1.,-dx/1.,-dx/1.},
               length = length_bnd}

logging = {level=10}
minlevel = level

--  spatial object is composed by the attribute and Geometry

spatial_object = {
  {
    attribute = {
      kind = 'seed',  ------seed
    },
    geometry = {
      kind = 'canoND',
      object = {
        origin = { 2*dx, height*0.5, zpos },
        } --- object
    }
  },
  {
    attribute = {
      kind = 'boundary',  ---kind in attribute is seed/boundary/refinement/periodic
      label = 'north',     -- for north
      calc_dist = true,
    },
    geometry = {
      kind = 'canoND',    -- kind in geometry is canoND/sphere/stl 
      object = {
        origin = { -dx,height+dx_half,-dx },
        vec = {{length+4*dx,0.0,0.0},
               {0.0,0.0,4.*dx}}
        }
    }
  },
  {
    attribute = {
      kind = 'boundary',
      label = 'south',   --- for south
      calc_dist = true,
    },
    geometry = {
      kind = 'canoND',
      object = {
        origin = {-dx,-dx/2.,-dx},
        vec = {{length+4*dx,0.0,0.0},
               {0.0,0.0,4.*dx}}
        }
    }
  },
  {
    attribute = {
      kind = 'boundary',
      label = 'sphere'
    },
    geometry = {
      kind = 'sphere',
      object = {
        origin = sph_pos,
        radius = radius
      }
    }
  },
  {
    attribute = {
      kind = 'periodic', --kind is periodic
    },
    geometry = {
     {
      kind = 'periodic',
      object = {
       plane1 = {
          origin = {-dx,-dx,dx+dx/2.0},
          vec = {{length+4*dx,0.0,0.0},
               {0.0,height+2*dx,0.0}}
        },  --- plane1
        plane2 = {
          origin = {-dx,-dx,-dx/2.0},
          vec = {{0.0,height+2*dx,0.0},
                 {length+4*dx,0.0,0.0}}
        } --- plane2        
      }
    },
    {
     kind = 'periodic',
     object = {
       plane1 = {
         origin = {length+dx/2.0,-dx,-dx},
         vec = {{0.0,height+2*dx,0.0},
                {0.0,0.0,4.*dx}}        
       },
       plane2 = {
         origin = {-dx/2.0,-dx,-dx},
         vec = {{0.0,0.0,4.*dx},
                {0.0,height+2*dx,0.0}}
       }
      }  
    }
    }
  }
}


