require 'common'

bounding_cube = {
  origin = { inlet_x - dx_half, bottom_y - dx_half, back_z - dx_half },
  length = bounding_length,
}

minlevel = level

logging = { level = 5 }

spatial_object = {
  {
    attribute = { kind = 'seed', },
    geometry = {
      kind = 'canoND',
      object = { origin = { 2*D, 0, 0 }, }
    }
  }, -- seed

  {
    attribute = {
      kind = 'boundary',
      label = 'top_bottom',
    },
    geometry = {
      kind = 'canoND',
      object = {
        {  -- top plane
          origin = { inlet_x, top_y, back_z },
          vec = {
            {   L, 0.0, 0.0 },
            { 0.0, 0.0,   H },
          }
        },
        ----------------
        {  -- bottom plane
          origin = { inlet_x, bottom_y, back_z },
          vec = {
            {   L, 0.0, 0.0 },
            { 0.0, 0.0,   H },
          }
        },
      }, -- object
    }, -- geometry
  }, -- top

  {
    attribute = {
      kind = 'boundary',
      label = 'front_back',
    },
    geometry = {
      kind = 'canoND',
      object = {
        {  -- back plane
          origin = { inlet_x, bottom_y, back_z },
          vec = {
            {   L, 0.0, 0.0 },
            { 0.0,   H, 0.0 },
          }
        },
        ----------------
        {  -- front plane
          origin = { inlet_x, bottom_y, front_z },
          vec = {
            {   L, 0.0, 0.0 },
            { 0.0,   H, 0.0 },
          }
        },
      }, -- object
    }, -- geometry
  },


  { ------------------------------------------------------------
    attribute = {
      kind = 'boundary',
      label = 'inlet',
    },
    geometry = {
      kind = 'canoND',
      object = {
        origin = { inlet_x, bottom_y, back_z },
        vec = {
          { 0.0,   H,  0.0 },
          { 0.0, 0.0,    H },
        }
      }
    },
  }, -- inlet --------------------------------------------------

  { -------- Outlet --------------------------------------------
    attribute = {
      kind = 'boundary',
      label = 'outlet',
    },
    geometry = {
      kind = 'canoND',
      object = {
        origin = { outlet_x, bottom_y, back_z },
        vec = {
          { 0.0,   H,  0.0 },
          { 0.0, 0.0,    H },
        },
      },
    },
  }, -- outlet

  {
    attribute = { 
      kind = 'boundary',
      label = 'sphere',
      calc_dist = qValue,
      flood_diagonal = flood_diagonal,
      -- level = level,

      level = level + refine_level,
      distance_refine = {
        { level_offset =  0, radius = r1, },
        { level_offset = -1, radius = r2, },
        { level_offset = -2, radius = r3, },
      }
    },
    geometry = {
      kind = 'stl',
      format = 'binary',
      object = {
        filename = './sphere.stl',
      }
    },
    transformation = {
      deformation = 2.0
    --   deformation =  {          R,          R, R },
    --   translation =  { cylinder_x, cylinder_y, 0 },
    },
  },  -- cylinder
  {
    attribute = { 
      kind = 'refinement',
      level = level + refine_level,
    },
    geometry = {
      kind = 'ellipsoid',
      object = {
        origin = {0.0,0.0,0.0},
        radius = {R+R,R+r1,R+r1}
      }
    },
    transformation = {
      translation = {R,0.0,0.0}
    }
  },
  {
    attribute = { 
      kind = 'refinement',
      level = level + refine_level-1,
    },
    geometry = {
      kind = 'ellipsoid',
      object = {
        origin = {0.0,0.0,0.0},
        radius = {R+2*R,R+r2,R+r2}
      }
    },
    transformation = {
      translation = {2.0*R,0.0,0.0}
    }
  },  
  {
    attribute = { 
      kind = 'refinement',
      level = level + refine_level-2,
    },
    geometry = {
      kind = 'ellipsoid',
      object = {
        origin = {0.0,0.0,0.0},
        radius = {R+3*R,R+r3,R+r3}
      }
    },
    transformation = {
      translation = {3*R,0.0,0.0}
    }
  },
}
