require "common"

simulation_name = 'lbm_mrt_les'
sim_control = {
  time_control = {
    max = { iter = 100 },
    interval = { iter = 100 },
  }
}

physics = { dt = dt, rho0 = rhoPhy }

scheme = {
  identify = {
    label = scheme_label,
    kind = 'lbm',
    relaxation = 'mrt_les',
    layout = layout,
  }, -- identify table

  fluid = { omega = omega, rho0 = rhoPhy },

  -- Initial condition for each field
  initial_condition = {
    pressure  = ic_pressure,
    velocityX = ic_velocityX,
    velocityY = ic_velocityY,
    velocityZ = 0.0,
    Sxx = ic_Sxx,
    Syy = ic_Syy,
    Szz = 0.0,
    Sxy = 0.0,
    Syz = ic_Syz,
    Sxz = ic_Sxz,
  }, -- intitial condition end

} -- scheme table
