require "common"

sim_control = {
  time_control = {
    max = tEnd,
    interval = tEnd / 1,
  }
}

physics = { dt = dt, rho0 = rhoPhy }

scheme = {
  identify = {
    label = scheme_label,
    kind = kind,
    relaxation = relaxation,
    layout = layout,
  }, -- identify table

  fluid = { omega = omega, rho0 = rhoPhy },

  -- Initial condition for each field
  initial_condition = {
    pressure  = ic_pressure,
    velocityX = ic_velocityX,
    velocityY = ic_velocityY,
    velocityZ = 0.0,
    Sxx = ic_Sxx,
    Syy = ic_Syy,
    Szz = 0.0,
    Sxy = 0.0,
    Syz = ic_Syz,
    Sxz = ic_Sxz,
  }, -- intitial condition end

  --variable = {
  --    { name = 'refPressure', 
  --      ncomponents = 1,
  --      vartype = 'st_fun',
  --      st_fun = pressure },
  --    { name ='refVelMag', 
  --      ncomponents = 1, 
  --      vartype = 'st_fun'
  --      st_fun = velocity },
  --    { name = 'refVelocityX',
  --      ncomponents = 1, 
  --      vartype = 'st_fun',
  --      st_fun = velocityX },
  --    { name = 'refVelocityY', 
  --      ncomponents = 1, 
  --      vartype = 'st_fun',
  --      st_fun = velocityY },
  --    { name = 'refSxx', 
  --      ncomponents = 1,
  --      vartype = 'st_fun',
  --      st_fun = Sxx },
  --    { name = 'refSyy', 
  --      ncomponents = 1, 
  --      vartype = 'st_fun',
  --      st_fun = Syy },
  --    { name = 'refKe', 
  --      ncomponents = 1, 
  --      vartype = 'st_fun',
  --      st_fun = kinetic_energy },
  --},

  racking = {
    { -- Average Kinetic energy (KE) spatial
     label = 'L'..level..'_ke',
     variable = {
        'kinetic_energy_phy' ,
       -- 'refKe' ,
     },
     reduction = {'sum'},
     folder = 'tracking/',
     shape = { kind = 'all', },
     format = 'ascii',
     time_control = {
       min = 0,
       max = tEnd,
       interval = dt,
     },
    },
  } -- track table
} -- scheme table
