#!/usr/bin/env python
'''
This file plots Speedup plot,Parallel efficiency plot and
runtime plot from the output file 'timing.res'
timing.res is genetared after successful execution of musubi.

'''
# This plots the graph after the scaling tests
# It generates the following three plots from the output. 
# plot1.ps - Runtime against Numprocs
# plot2.ps - MLUPS against Numprocs
# plot3.ps - parallel efficiency against Numprocs
# Usage:
# ./2_plot.py
# it also leaves a gnu plot file in the output.

import os
import sys
import string
import subprocess
from time import strftime
from subprocess import call


date = strftime("%d-%m-%Y")
plot_file = 'timing.res'

# get domain size from the timing.res file
file = open(plot_file, "r")
data = file.readlines()
file.close()
datal1= string.split(data[1])
#print dom_size[0]
#get the MLUPS when run with 1 processor
#to be used in parallel efficiency plots
mlups=float(datal1[2])
t_proc1=float(datal1[8])



# create a gnuplot script to plot graph
# graph1 - (Numprocs against runtime)
gnu = open("plot1.gnu",'w')
gnu.write("set term png \n")
gnu.write("set output \'plot1.png\'\n")
gnu.write("set xtics auto \n")
gnu.write("set ytics auto \n")
gnu.write("set title \"Runtime Plot\" \n")
gnu.write("set xlabel \"NumProcs\" \n")
gnu.write("set ylabel \"Time-Mainloop\"  \n")
gnu.write("plot \"%s\" u 2:($9/(%s)) title '%s elements' \n" %(plot_file,t_proc1,datal1[0]) )
gnu.close()

subprocess.call("gnuplot 'plot.gnu' ", shell=True )


# speed-up-plot
gnu = open("plot2.gnu",'w')
gnu.write("set term png\n")
gnu.write("set output \'plot2.png\'\n")
gnu.write("set xtics auto \n")
gnu.write("set ytics auto \n")
gnu.write("set title \"Speedup\" \n")
gnu.write("set xlabel \"NumProcs\" \n")
gnu.write("set ylabel \"Speedup(in terms of MLUPS)\"  \n")
gnu.write("plot \"%s\" u 2:($3/(%s)) title '%s elements',x title'Ideal speedup' \n" %(plot_file,mlups,datal1[0]) )
gnu.close()

subprocess.call("gnuplot 'plot2.gnu' ", shell=True )


# parallel efficiency
gnu = open("plot3.gnu",'w')
gnu.write("set term png \n")
gnu.write("set output \'plot3.png\'\n")
gnu.write("set xtics auto \n")
gnu.write("set ytics auto \n")
gnu.write("set title \"Parallel Efficiency\" \n")
gnu.write("set xlabel \"NumProcs\" \n")
gnu.write("set ylabel \"Parallel Efficiency\"  \n")
gnu.write("plot \"%s\" u 2:($3/($2*%s)) title '%s elements',1 title 'ideal efficiency' linewidth 2 \n" %(plot_file,mlups,datal1[0]) )
gnu.close()

subprocess.call("gnuplot 'plot3.gnu' ", shell=True )

#clear up the plot files
#call(["rm","plot.gnu","plot3.gnu","plot2.gnu"])

