-- Musubi configuration file. 
-- This is a LUA script.

-- Local refinement settings
interpolation_method = { 'linear', value = 0.5 }
--interpolation_method = 'average'
                     
debug = {debugMode = false, debugFiles = false}

-- Time step settigs
tmax           =  50   -- total iteration number
check_interval =  tmax   -- iteration check interval

originX =  -1.3
originY =  0.8
originZ =  0.1
halfwidth = 0.50
amplitude = 0.01
background = 1.0

function ic_1Dgauss_pulse(x, y, z)
  return background+amplitude*math.exp(-0.5/(halfwidth^2)*( x - originX )^2)
end
function ic_2Dgauss_pulse(x, y, z)
  return background+amplitude*math.exp(-0.5/(halfwidth^2)*(( x - originX )^2+( y - originY )^2))
end
-- Initial condition 
initial_condition = { density = ic_2Dgauss_pulse,
                      velocityX = 0.0,
                      velocityY = 0.0,
                      velocityZ = 0.0 }
-- Simulation name
simulation_name = 'gaussian'
mesh = 'mesh/'-- Mesh information

fluid = { relaxation_scheme = 'BGK', omega = 1.8, rho0 = 1.0 }

-- Boundary conditions
boundary_condition = {  
--{ label = 'east',
  -- kind = 'wall', density = 1.0, order = 1 }
--  kind = 'outlet_nrbc', density = 1.0, sigma = 0.1, kappa = 1.2, L = 100. }
--{ label = 'right',
--   kind = 'outlet_extrapolation', density = 1.0, order = 3 }
--,{ label = 'west',
--   kind = 'wall', velocityX = 0.0001, velocityY = 0.0, velocityZ = 0.0, density = 1.0 }
--,{ label = 'north',
--   kind = 'wall', density = 1.0 }
--,{ label = 'south',
--   kind = 'wall', density = 1.0 }
--,
{ label = 'wall',
   kind = 'wall' }
}

-- Output settings
output = { active = false, -- VTK output activated?
  folder = 'output/',     -- Output location
  vtk = true,             -- VTK output activated?
  dumpGhosts = true,      -- VTK output activated?
  dumpHalos = true,      -- VTK output activated?
  interval = 1, -- tmax/40,    -- output interval 
  tmin = 1,                  -- first iteration to output
  tmax = -1 }             -- last iteration to output

-- Tracking              
racking = {
 { label = 'probe_density', 
 variables = {'density'}, 
 type='point', point ={1.,0.,0.},
 interval = 1, tmin = 0, tmax = -1 } 
 }


-- Restart settings
restart = {
  -- If this table is available it will read the restart file
  -- given below.
  ead =  {
    folder    = 'restart/', -- folder of the restart file
    file_name = 'lastHeader.lua'                       -- the restart file to read
  },
  -- If this table is available it will write a restart file
  -- with the specified options.
  write = {
    folder    = 'restart/', -- the folder the restart files are written to
    interval  = 1,                                     -- dump restart file interval
    tmin      = tmax,                                     -- first timestep to output
    tmax      = tmax                                     -- last timestep to output
  }
}
