require "common"
-- Use this file as template. Do not modify this file for running some testcases
outputname = 'channel_2D'
outputpreview = true 

-- general refinement levels
-- minrefine: defines minimum refinement level of the entire domain
--
-- maxrefine: defines maximum refinement
-- gets overwritten from madatory STL levels
-- will become default for stl refinement level once
-- it is not mandatory any more
minrefine = 1
maxrefine = 3
-- stl_files: for each stl file put a table into
-- this table of tables. Or just a string for
-- the filname, if the other two parameters should
-- get the default: boundary_type = 1, fileformat = 'binary'
-- refinementlevel is the level to which the stl shall be refined
-- it is mandatory

--stl_files = {{filename = 'stl/inlet.stl', 
--              bclabel = 'inlet', 
--              format = 'binary' } ,
--             {filename = 'stl/wall.stl', 
--              bclabel = 'wall', 
--              format = 'binary' } ,
--             {filename = 'stl/outlet.stl', 
--              bclabel = 'outlet', 
--              format = 'binary' } 
--}
--
-- boundingbox: two entries: origin and length in this
-- order, if no keys are used
boundingbox = {origin = {-length*0.5, -length*.5, -length*0.5},
               length = length}

-- refinebox: three entries: origin, length and refinementlevel
refinebox = {{origin = {-length*0.5, -height*.5, -dx},
            length = {length, height, 2.0*dx},
            refinementlevel = level
            },
            {origin = {-length*0.2, -height/6+dxDash, -dx},
            length = {length*0.4, height/3-2.*dxDash, 2.0*dx},
            refinementlevel = level+refinementLevel
            }
            }               

-- seed: originition of seed 
seed = {0.0, 0.0, 0.0 }

geom={
     plane={
            {vecA={0.0,length,0.0},
              vecB={0.0,0.0,length},
              pos={length*0.5,-length*0.5,-length*0.5},
  	          bclabel='east',
              refinementlevel = 3}
            ,{vecA={0.0,length,0.0},
              vecB={0.0,0.0,length},
              pos={-length*0.5,-length*0.5,-length*0.5},
	            bclabel='west',
              refinementlevel = 3}
             ,{vecA={length,0.0,0.0},
       	      vecB={0.0,0.0,length},
      	      pos={-length*0.5,height*0.5+dxDash,-length*0.5},
	            bclabel='north',
              refinementlevel = 3}
             ,{vecA={length,0.0,0.0},
	            vecB={0.0,0.0,length},
      	      pos={-length*0.5,-height*0.5-dxDash,-length*0.5},
	            bclabel='south',
              refinementlevel = 3}
             }
   ,periodic = {        
            {
            plane1 = 
            {vecA={length,0.0,0.0},
             vecB={0.0,length,0.0},
             pos={-length*0.5,-length*0.5,dx+dxDash}},
            plane2 = 
            {vecB={length,0.0,0.0},
             vecA={0.0,length,0.0},
             pos={-length*0.5,-length*0.5,-dxDash}}
          }}
}
