outputname = 'crvp'
outputpreview = true 
folder = 'mesh/'

-- stl_files: for each stl file put a table into
-- this table of tables. Or just a string for
-- the filname, if the other two parameters should
-- get the default: boundary_type = 1, fileformat = 'binary'
-- refinementlevel is the level to which the stl shall be refined
-- it is mandatory
stl_files = {{filename = 'box.stl', 
              bclabel = 'wall', 
              format = 'binary'}
              }


-- boundingbox: two entries: origin and length in this
-- order, if no keys are used
-- general refinement levels
-- minrefine: defines minimum refinement level of the entire domain
--
-- maxrefine: defines maximum refinement
-- gets overwritten from madatory STL levels
-- will become default for stl refinement level once
-- it is not mandatory any more
maxrefine = 5
minrefine = maxrefine

boundingbox = {origin = {-5.0,-5.0,-5.0},
               length = 10.}
-- refinebox: three entries: origin, length and refinementlevel
--refinebox = {
--              {origin = {-0.75, -0.75, -5.},
--              length = {1.5, 1.5, 10.0},
--              refinementlevel = maxrefine+2
--              },
--              {origin = {-2.5, -2.5, -5.0},
--              length = {5.0, 5.0, 10.0},
--              refinementlevel = maxrefine+1
--              }
--            }               
-- seed: position of seed 
seed = { points = { {0.1,0.1,0.25}}
       }
-- plane definition
-- definition 1
-- plane is defined by two vectors and position in x,y,z coordinate
-- with reference to origin 
-- pos - position to trasform plane from its origin
-- vecA- vector A from its origin ( defines plane length ) 
-- vecB- vector B from its origin ( defines plane width ) 
--  origin-----------> vecA
--        | -        |
--        |   -A+B   |
--        |     -    |
--        |       -  |
--   vecB v----------x 

-- example plane at xy-plane normal to z-axis
-- offset from z-plane at 1.0
-- starting at x = -1.0 and y = -1.0 
-- length and width of plane is 2.0
geom={
     plane={
             {vecA={0.0, 0.3,0.0},
              vecB={0.0,0.0,10.0},
              pos={3.5, 3.1,-5.0},
  	          bclabel='wall',
              refinementlevel = minLevel}
}}

