-- Musubi configuration file. 
-- This is a LUA script.

level=4

-- Simulation name
simulation_name = 'pulse'..level

-- Mesh information
-- mesh = 'mesh/mesh_2M/'
mesh = { predefined = 'cube',
         origin = {0.0, 0.0, 0.0},
         length = 10.0,
         refinementLevel = level
       }

nprocs=2

-- *************************************************************
--        THESE COMMUNICATION PATTERNS ARE NOT WORKING
-- *************************************************************
commpattern = 'gathered_type' -- 'typed_isend_irecv'

-- Time step settings
tmax           = 10 -- math.min((math.pow(8, 9)*nprocs) / math.pow(8, mesh.refinementLevel), 1000000)
interval = tmax    -- iteration check interval
control_routine='fast'

time = {useIterations = true, max = tmax, interval = interval, min = 1}

fluid = { relaxation_scheme = 'BGK', omega = 1.8, rho0 = 1.0 }

-- Initial Case
initial_condition = { 
                     density = {predefined='gausspulse', 
                                center={5.0, 5.0, 5.0}, 
                                halfwidth=1.0, 
                                amplitude=1.20, 
                                background=1.000}, 
                    velocityX = 0.0,
                    velocityY = 0.0,
                    velocityZ = 0.0
                   }

interpolation_method = 'linear'                     

-- Ramping settings  
ramping        = false

-- Output settings
--output = { active = false,
--           vtk = true,     -- VTK output activated?
--           interval = -1,        -- output interval 
--           tmin = 0,         -- first iteration to output
--           tmax = 0 } 
