require 'common'

bounding_cube = {
  origin = { bounding_x, bounding_x, bounding_x },
  length = bounding_length,
}

shepherd = true
if shepherd then
  stlFolder = '$!stl_path!$'
else
  stlFolder = './'
end

minlevel = 5

logging = { level = 1 }

timing_file = 'sdr_timing.res'

spatial_object = {
  {
    attribute = { kind = 'seed', },
    geometry = {
      kind = 'canoND',
      object = { origin = { outlet_x - 2*D, 0, 0 }, }
    }
  }, -- seed

  {
    attribute = {
      kind = 'boundary',
      label = 'side',
    },
    geometry = {
      kind = 'canoND',
      object = {
        {  -- top plane
          origin = { inlet_x, top_y, back_z },
          vec = {
            {   L, 0.0, 0.0 },
            { 0.0, 0.0,   H },
          }
        },
        ----------------
        {  -- bottom plane
          origin = { inlet_x, bottom_y, back_z },
          vec = {
            {   L, 0.0, 0.0 },
            { 0.0, 0.0,   H },
          }
        },
      }, -- object
    }, -- geometry
  }, -- top

  {
    attribute = {
      kind = 'boundary',
      label = 'side',
    },
    geometry = {
      kind = 'canoND',
      object = {
        {  -- back plane
          origin = { inlet_x, bottom_y, back_z },
          vec = {
            {   L, 0.0, 0.0 },
            { 0.0,   H, 0.0 },
          }
        },
        ----------------
        {  -- front plane
          origin = { inlet_x, bottom_y, front_z },
          vec = {
            {   L, 0.0, 0.0 },
            { 0.0,   H, 0.0 },
          }
        },
      }, -- object
    }, -- geometry
  },


  { ---  Inlet     ---------------------------------------------
    attribute = {
      kind = 'boundary',
      label = 'inlet',
    },
    geometry = {
      kind = 'canoND',
      object = {
        origin = { inlet_x, bottom_y, back_z },
        vec = {
          { 0.0,   H,  0.0 },
          { 0.0, 0.0,    H },
        }
      }
    },
  }, -- inlet --------------------------------------------------

  { -------- Outlet --------------------------------------------
    attribute = {
      kind = 'boundary',
      label = 'outlet',
    },
    geometry = {
      kind = 'canoND',
      object = {
        origin = { outlet_x, bottom_y, back_z },
        vec = {
          { 0.0,   H,  0.0 },
          { 0.0, 0.0,    H },
        },
      },
    },
  }, -- outlet

  { -------- Refinement BOX
    attribute = {
      kind = 'refinement',
      label = 'refinebox',
      level = level,
    },
    geometry = {
      kind = 'canoND',
      object = {
        origin = { inlet_x, bottom_y, back_z },
        vec = {
          {   L,   0,    0 },
          { 0.0,   H,  0.0 },
          { 0.0, 0.0,    H },
        },
      },
    },
  }, -- Refinement box

  { ------------- SPHERE ---------------------------------
    attribute = {
      kind = 'boundary',
      label = 'cylinder',
      calc_dist = qValue,
      flood_diagonal = flood_diagonal,
      level = level,
    },
    geometry = {
      kind = 'stl',
      format = 'binary',
      object = {
        filename = stlFolder..'sphere.stl',
      },
    },
    transformation = {
      deformation = 12,
    },
  }
}
