! See copyright notice in the COPYRIGHT file.
! ****************************************************************************** !
!! author: Kartik Jain
!> This module contains the code responsible for adaptively refining the mesh
!! during run time. 
!!
module mus_mesh_adaptation_module

  ! include treelm modules
  use mpi
  use env_module,               only: rk, long_k
  use tem_adaptation_module,    only: tem_adapt_dump_newMesh
  use tem_comm_env_module,      only: tem_comm_env_type
  use tem_adaptation_config_module, only: tem_adapt_type

  ! include musubi modules
  use mus_scheme_type_module,   only: mus_scheme_type
  use mus_geom_module,          only: mus_geom_type

  implicit none

  private

  public :: mus_adapt_refine

contains

! ****************************************************************************** !
  !> Wrap up the routines required for dynamic load balancing
  subroutine mus_adapt_refine( geometry, scheme, proc, adapt )
    ! ---------------------------------------------------------------------------
    !> Treelmesh data
    type( mus_geom_type )       , intent(inout)     :: geometry
    !> scheme type
    type( mus_scheme_type )     , intent(inout)     :: scheme
    type(tem_comm_env_type)     , intent(in)        :: proc
    !> mesh adaptation
    type(tem_adapt_type)        ,  intent(in)       :: adapt
    ! ---------------------------------------------------------------------------

    ! Now you get the adaptively refined mesh back
    ! Dump it to the disk at the current moment
    call tem_adapt_dump_newMesh( levelDesc    = scheme%levelDesc, &
      &                          tree         = geometry%tree,    &
      &                          proc         = proc              )

  end subroutine mus_adapt_refine

end module mus_mesh_adaptation_module
