! See copyright notice in the COPYRIGHT file.
! ****************************************************************************** !
!> This module contains routines which initiliaze advection relaxation and
!! flow field for lbm incompressible model.
module mus_initLBMIncomp_module
  ! include treelm modules
  use env_module,         only: labelLen
  use tem_aux_module,     only: tem_abort
  use tem_logging_module, only: logUnit

  ! include musubi modules
  use mus_bgk_module,   only: bgk_advRel_explicit_incomp
  use mus_d3q19_module, only: bgk_advRel_d3q19_incomp_les,                     &
    &                         bgk_advRel_d3q19_incomp,                         &
    &                         trt_advRel_d3q19_incomp
  use mus_d3q19_turb_module, only: bgk_advRel_d3q19_incomp_les_new
  use mus_d2q9_module,  only: bgk_d2q9_incomp, mrt_d2q9_incomp
  use mus_mrt_module,   only: mrt_advRel_d3q19_incomp,                         &
    &                         mrt_advRel_d3q19_incomp_explicit,                &
    &                         mrt_advRel_d3q19_incomp_les,                     &
    &                         mrt_advRel_incomp_explicit
  use mus_scheme_type_module, only: kernel

  implicit none

  private

  public :: mus_init_advRel_lbmIncomp

contains

! ****************************************************************************** !
  !> Initialize the relaxation model for lbm incompressible model
  subroutine mus_init_advRel_LBMIncomp( relaxation, layout, compute )
    ! ---------------------------------------------------------------------------
    character(len=labelLen), intent(inout) :: relaxation
    character(len=labelLen), intent(in) :: layout
    procedure( kernel ), pointer, intent(out) :: compute
    ! ---------------------------------------------------------------------------
    write(logUnit(1),*) 'Choosing INCOMPRESSIBLE relaxation model: '           &
      &                 //trim( relaxation )

    select case( trim( relaxation ))
    case( 'bgk_explicit' )
      compute => bgk_advRel_explicit_incomp
    case( 'mrt_les' )
      select case( trim(layout) )
      case( 'd3q19' )
        compute => mrt_advRel_d3q19_incomp_les
      case default
        write(logUnit(1),*) 'Stencil '//trim(layout)//' is not supported yet!'
        call tem_abort()
      end select
    case( 'bgk_les' )
      select case( trim(layout) )
      case( 'd3q19' )
        compute => bgk_advRel_d3q19_incomp_les
      case default
        write(logUnit(1),*) 'Stencil '//trim(layout)//' is not supported yet!'
        call tem_abort()
      end select
    case( 'bgk_les_new' )
      select case( trim(layout) )
      case( 'd3q19' )
        compute => bgk_advRel_d3q19_incomp_les_new
      case default
        write(logUnit(1),*) 'Stencil '//trim(layout)//' is not supported yet!'
        call tem_abort()
      end select
    case( 'bgk' )
      select case( trim(layout) )
      case( 'd3q19' )
        compute => bgk_advRel_d3q19_incomp
      case( 'd2q9' )
        compute => bgk_d2q9_incomp
      case default
        compute => bgk_advRel_explicit_incomp
      end select
    case( 'mrt' )
      select case( trim(layout) )
      case( 'd3q19' )
        compute => mrt_advRel_d3q19_incomp
      case( 'd2q9' )
        compute => mrt_d2q9_incomp
      case default
        write(logUnit(1),*) 'Stencil '//trim(layout)//' is not supported yet!'
        call tem_abort()
      end select
    case( 'trt' )
      select case( trim(layout) )
      case( 'd3q19' )
        compute => trt_advRel_d3q19_incomp
      case default
        write(logUnit(1),*) 'Stencil '//trim(layout)//' is not supported yet!'
        call tem_abort()
      end select
    case( 'mrt_explicit', 'mrt_bgk' )
      select case( trim(layout) )
      case( 'd3q19' )
        compute => mrt_advRel_d3q19_incomp_explicit
      case( 'd2q9', 'd3q27' )
        compute => mrt_advRel_incomp_explicit
      case default
        write(logUnit(1),*) 'Stencil '//trim(layout)//' is not supported yet!'
      end select
    case default
      write(logUnit(1),*) 'Relaxation '//trim(relaxation)//' is not supported!'
      call tem_abort()
    end select

  end subroutine mus_init_advRel_LBMIncomp
! ****************************************************************************** !

end module mus_initLBMIncomp_module
