title: Documentation

## Usage
- [Quick Start: Building and Compiling Musubi](usage/index.html)
- [Configuring Simulation Runs](../module/mus_config_module.html)
- [Requirements: Treelm](treelm/page/requirements.html)

## Getting Started
- [Tutorials](tutorial/index.html)

  An introduction to the usage of the features of Musubi.
  You are guided through all required steps from generating meshes,
  configuring the solver and post-processing the results.
  [Basic Features](#basic-features)

  You can choose between special topics or you can go step by step through
  the tutorials.

## Basic Features <a id="basic-features" />
* [Boundary Conditions (module)](../module/mus_bc_header_module.html)
   * [Tutorial](tutorial/tut_4_boundaries.html)
   * [Space-dependent definitions](../proc/tem_load_spatial.html)
   * [Transient definitions](../proc/tem_load_temporal.html)
   * [Space-Time definitions](../proc/tem_load_spacetime_single.html)
* [Description of the multi-level algorithm](features/comp_proc.html)
* [Restart](../module/tem_restart_module.html)
   * [Tutorial](tutorial/tut_5_restart.html)
* [Tracking](../module/tem_tracking_module.html)
   * [Tutorial](tutorial/tut_3_tracking.html)
* [Multilevel](../module/mus_interpolate_module.html#interpolation-of)
   * [Tutorial](tutorial/tut_00_mus_multilevel.html)
* [Construction of the data structures](features/data_struc.html)
* [Interpolation methods](features/intp_methods.html#quadratic)
* [Multispecies](features/multispecies.html)

## The Octree Data structure
* [Treelm Framework](treelm/module/treelmesh_module.html)
* [Treelmesh type](treelm/type/treelmesh_type.html)
* [Distributed Octree](treelm/page/octree.html)
