Musubi
======

Musubi is the multi-level parallel lattice Boltzmann solver within the APES
suite. It is working on a linearized octree and uses efficient data structures
allowing adaptive parallel simulations. Musubi offers several collision kernels
and is designed in a way to deal with huge meshes very efficiently.

How to compile
--------------

Musubi makes use of the [waf](http://code.google.com/p/waf), to manage the
compilation.

You will need to have an MPI wrapper for your Fortran compiler and have the
*FC* environment variable set to that, typically that is:
    export FC=mpif90

You can configure your compilation with:

    ./waf configure

and then build the executable with

    ./waf build


How to run
--------------------

Musubi comes with a collection of cases so you can start simulating right away.
Have a look at the testsuite/physics folder.

Documentation
-------------

For further details see the
[Doxygen documentation](https://geb.sts.nt.uni-siegen.de/doxy/musubi/index.html).

Included Software
-----------------

Note, that this source code includes some other software parts to your convenience.

- [Treelm](https://bitbucket.org/apesteam/treelm/) is the central library
  providing the octree infrastructure. It is available under the terms of the
  BSD License.
- [Aotus](https://bitbucket.org/apesteam/aotus/) is used for configuration and header
  files. It is released under the terms of the MIT License as the
  [Lua library](http://www.lua.org), that it includes.
- [Waf](http://code.google.com/p/waf/) is used as the build system and is released
  under the terms of the BSD license.
- [CoCo](http://users.erols.com/dnagle/coco.html) is used to preprocess Fortran
  source files and is released under the terms of the GPLv2.

License
=======

Musubi is licensed under the terms of the 2-clause BSD license reproduced below.
This means that Seeder is free software and can be used, reproduced, modified,
distributed and redistributed also for commercial purposes under the conditions
of the BSD license.
The only requirement is that some credit to the authors is given by putting this
copyright notice somewhere in your project.

According to good scientific practice, publications on results achieved in whole
or in part due to Seeder should cite at least one paper presenting the Seeder
software.

---
Copyright (C) 2011-2013 German Research School for Simulation Sciences GmbH, Aachen.
Copyright (C) 2013-2019 University of Siegen.
All rights reserved.
 
Redistribution and use in source and binary forms, with or without modification,
are permitted provided that the following conditions are met:
 
1. Redistributions of source code must retain the above copyright notice, this
list of conditions and the following disclaimer.
 
2. Redistributions in binary form must reproduce the above copyright notice,
this list of conditions and the following disclaimer in the documentation and/or
other materials provided with the distribution.
 
THIS SOFTWARE IS PROVIDED BY THE UNIVERSITY OF SIEGEN “AS IS” AND ANY EXPRESS
OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF
MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
IN NO EVENT SHALL UNIVERSITY OF SIEGEN OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT,
INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING,
BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF
LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE
OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF
ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 
The views and conclusions contained in the software and documentation are those
of the authors and should not be interpreted as representing official policies,
either expressed or implied, of German Research School for Simulation Sciences
GmbH, Aachen or University of Siegen.
