-- Configuration file for Ateles --
nprocs = 1
level = 5

-- global simulation options
simulation = {
              name          = 'gauss_pulse_euler',                 -- the name of the simualtion
              final_time    = 0.01  
             }

--commpattern = 'gathered_type'

-- Mesh definitions --
 mesh = './mesh/'

-- Restart settings
restart = { ead = 'restart/gauss_pulse_euler_lastHeader.lua',
            write = 'restart/',
            time = { useIterations = false,  min = 0, max = 0.01, interval = 0.001}}

-- timing settings (i.e. output for performance measurements, this table is otional)
timing = {
          folder = './',                                             -- the folder for the timing results
          filename = 'timing.res'                                    -- the filename of the timing results
         }


-- Equation definitions --
equation = {
    name   = 'euler',
    therm_cond = 2.555e-02,
    isen_coef = 1.4,
    r      = 296.0,
}


-- (cv) heat capacity and (r) ideal gas constant
equation["cv"] = equation["r"] / (equation["isen_coef"] - 1.0)

-- Scheme definitions --
scheme = {
    -- the spatial discretization scheme
    spatial =  {
               name = 'muscl',             -- we use the weno scheme for reconstruction
               }, 
    -- the temporal discretization scheme
    temporal = {
               name = 'explicitRungeKutta',    -- we use explicit runge kutta in time
               steps = 4,                      -- we have a 3 stage 
               -- how to control the timestep
               control = {
                          name = 'cfl',   -- the name of the timestep control mechanism
                          cfl  = 0.3,     -- CourantFriedrichsLewy number
                         },
               },
}

-- This is a very simple example to define constant boundary condtions.
initial_condition = { density = {predefined='gausspulse',
                                 center={5.0, 5.0, 5.0},
                                 halfwidth=2.0,
                                 amplitude=2.0,
                                 background=1.225},
                      pressure = 100000,
                      velocityX = 10.0,
                      velocityY = 0.0,
                      velocityZ = 0.0}

boundary_condition = {
           { label = 'north', kind = 'outflow', pressure = 'extrapolate', density = 'extrapolate' },
           { label = 'south', kind = 'outflow', pressure = 'extrapolate', density = 'extrapolate' },
           { label = 'west', kind = 'outflow', pressure = 'extrapolate', density = 'extrapolate' },
           { label = 'east', kind = 'outflow', pressure = 'extrapolate', density = 'extrapolate' },
           { label = 'top', kind = 'outflow', pressure = 'extrapolate', density = 'extrapolate' },
           { label = 'bottom', kind = 'outflow', pressure = 'extrapolate', density = 'extrapolate' } }
