#!/bin/sh
# This script runs harvester on a set of restart files from
# tracking entities to harvest and create .vtk
# Author: Manuel Hasert m.hasert@grs-sim.de
# You have to specify the harvester binary path 
harvester='../../../../harvester/build/harvester'
# THe folder, where the tracking / restart files are, which have to be processed
#restart_folder='restart/test3/predefined_gauss_pulse_euler_muscl_euler_1/write_predefined_gauss_pulse_euler_muscl_eu'
restart='restart/'
harvest='harvest/'
test_='test3/'
case='parabol_3d_euler_muscl_euler_4/'
restart_folder="$restart/$test_/$case/"
# And the output folder, where to create the vtk
output_folder="$harvest/$test_/$case/"
# Series harvesting lua script
series_lua=harvest/harvest_series.lua
# Simulation Name
simulation_name='parallel_verification2'


echo 
echo 'Harvester processing script'
echo 
echo  'Checking for binary...'
if [ -e "${harvester}" ]; then
  echo 'Running with '${harvester}
else
  echo  'Binary not found. Aborting ...'
  exit
fi
echo 
if [ "X$@" = "X" ]; then
  echo  'Please provide the files to process as arguments'
  echo  'Example:'
  echo 
  echo  '  ./harvest.sh tracking/*.lua'
  echo 
  echo  'Aborting ...'
  exit
fi

mkdir $harvest/$test_
mkdir $output_folder

echo 'Restart folder    :' ${restart_folder}
#echo 'deleting old output folder' ${output_folder}
#rm -rf $output_folder
#mkdir $output_folder

restartfile_list=$@ #`ls ${restart_folder}/*.lua`‚
echo 'Processing ' ${restartfile_list}

x=0
for restartfile in $restartfile_list; do
  echo 
  echo Running Harvester with Restart header $restartfile
  echo 
  export RESTARTFOLDER="./$restartfile"
 # export RESTARTHEADER="$restartfile"
  export output_folder="$output_folder"
  export SIMULATIONNAME="$simulation_name"_$x
  $harvester $series_lua
  echo 
  echo
  x=$(($x+1))
done
