---- testcase setup------------------------------------------------------------
gamma = 1.4
dens = 1.0
velX = 0.0
velY = 0.0
velZ = 0.0
press = 1/gamma
c = math.sqrt(gamma* press / dens)
gp_center = {0.0, 0.0, 0.0}
gp_halfwidth = 3.0
gp_amplitude = 0.001
gp_background = press
gp_c = c

cfl= 0.5
dt = 0.015

-----simulation setup-----------------------------------------------------------
timestep_info = 1
check =  {
           interval = 1,
         }
tmax = 35.0
track_dt = 0.01
line_track_dt = 2.0
degree = 5
-- Scheme definitions --
scheme = {
  -- the spatial discretization scheme
  spatial =  {
    name = 'modg',
    modg_space = 'Q',
    m = degree,
  },
  -- the temporal discretization scheme
  temporal = {
    name = 'explicitSSPRungeKutta',
    steps = 2,
    control = {
      name = 'fixed',
      dt = dt
--      name = 'cfl',
--      cfl  = 0.8,
    },
  },
}
-- the general projection table --
projection = {
  kind = 'l2p',
  factor = 1.0,
}

