require 'common'

logging = {level=7}

-- global simulation options
simulation_name='ateles_lineuler' 
sim_control = {
  time_control = {
    min = 0,
    max = tmax,
    interval = {iter = 100}, -- final simulation time
  }
}
-- table for preCICE
precice = {
           accessor = 'Ateles_lineuler',
           configFile ='precice_config.xml',
          }

-- Tracking
segments = 60*(degree+1)
NOtracking = {
  -- Line tracking
  {
    label = 'lineX_pressure',
    folder = './track_pulse/lineuler/',
    variable = {'full_pressure', 'ref_pressure', 'error'},
    shape = {
      kind = 'canoND',
      object = {
        -- close to center
        origin   = { -30.0, 0.0, 0.0 },
        vec      = { 60.0, 0.0 ,0.0},
        segments = { segments},
      },
    },
    time_control = {min = 0, max = tmax, interval = line_track_dt},
    output = { format = 'asciiSpatial', use_get_point = true},
  },
  {
    label = 'lineY_pressure',
    folder = './track_pulse/lineuler/',
    variable = {'full_pressure', 'ref_pressure', 'error'},
    shape = {
      kind = 'canoND',
      object = {
        -- close to center
        origin   = { 0.0, -30.0, 0.0 },
        vec      = { 0.0, 60.0 ,0.0},
        segments = { segments},
      },
    },
    time_control = {min = 0, max = tmax, interval = line_track_dt },
    output = { format = 'asciiSpatial', use_get_point = true},
  },
  {
    label = 'lineZ_pressure',
    folder = './track_pulse/lineuler/',
    variable = {'full_pressure', 'ref_pressure', 'error'},
    shape = {
      kind = 'canoND',
      object = {
        -- close to center
        origin   = { 0.0, 0.0, -30.0 },
        vec      = { 0.0, 0.0 ,60.0},
        segments = { segments},
      },
    },
    time_control = {min = 0, max = tmax, interval = line_track_dt},
    output = { format = 'asciiSpatial', use_get_point = true},
  },
  {
    label = 'west',
    folder = './track_pulse/lineuler/',
    variable = {'full_pressure', 'ref_pressure', 'error'},
    shape = {
      kind = 'canoND',
      object = {
        -- point west 
        { origin = { -10.01,0.0, 0.0 }},
      },
    },
    time_control = {min = 0, max = tmax, interval ={iter=1} },
    output = { format = 'ascii', use_get_point = true},
  },
  {
    label = 'east',
    folder = './track_pulse/lineuler/',
    variable = {'full_pressure', 'ref_pressure', 'error'},
    shape = {
      kind = 'canoND',
      object = {
        -- point east 
        { origin = {  10.01, 0.0, 0.0 }},
      },
    },
    time_control = {min = 0, max = tmax, interval ={iter=1} },
    output = { format = 'ascii', use_get_point = true},
  },
  {
    label = 'south',
    folder = './track_pulse/lineuler/',
    variable = {'full_pressure', 'ref_pressure', 'error'},
    shape = {
      kind = 'canoND',
      object = {
        -- point south
        { origin = { 0.0, -10.01, 0.0 }},
      },
    },
    time_control = {min = 0, max = tmax, interval ={iter=1} },
    output = { format = 'ascii', use_get_point = true},
  },
  {
    label = 'north',
    folder = './track_pulse/lineuler/',
    variable = {'full_pressure', 'ref_pressure', 'error'},
    shape = {
      kind = 'canoND',
      object = {
        -- point north
        { origin = {  0.0, 10.01, 0.0}},
      },
    },
    time_control = {min = 0, max = tmax, interval ={iter=1} },
    output = { format = 'ascii', use_get_point = true},
  },
  {
    label = 'top',
    folder = './track_pulse/lineuler/',
    variable = {'full_pressure', 'ref_pressure', 'error'},
    shape = {
      kind = 'canoND',
      object = {
        -- point top
        { origin = {  0.0, 0.0, 10.01}},
      },
    },
    time_control = {min = 0, max = tmax, interval ={iter=1} },
    output = { format = 'ascii', use_get_point = true},
  },
  {
    label = 'bottom,',
    folder = './track_pulse/lineuler/',
    variable = {'full_pressure', 'ref_pressure', 'error'},
    shape = {
      kind = 'canoND',
      object = {
        -- point bottom
        { origin = {  0.0, 0.0, 10.01}},
      },
    },
    time_control = {min = 0, max = tmax, interval ={iter=1} },
    output = { format = 'ascii', use_get_point = true},
  },
  {
    label = 'northwesttop,',
    folder = './track_pulse/lineuler/',
    variable = {'full_pressure', 'ref_pressure', 'error'},
    shape = {
      kind = 'canoND',
      object = {
        -- point north west top
        { origin = {  10.01, 10.01, 10.01}},
      },
    },
    time_control = {min = 0, max = tmax, interval ={iter=1} },
    output = { format = 'ascii', use_get_point = true},
  },
}


bg_dens = dens
bg_velX = velX
bg_velY = velY
bg_velZ = velZ
bg_press = press

variable = {
  -- add the background to varSys
  {
    name = 'bg_density',
    ncomponents = 1,
    vartype = 'st_fun',
    st_fun =  bg_dens,  
  },
  {
    name = 'bg_velocity',
    ncomponents = 3,
    vartype = 'st_fun',
    st_fun =  {bg_velX, bg_velY, bg_velZ}  
  },
  {
    name = 'bg_pressure',
    ncomponents = 1,
    vartype = 'st_fun',
    st_fun =  bg_press,  
  },
   -- get full states
  {
    name = 'full_density',
    ncomponents = 1,
    vartype = 'operation',
    operation = {
      kind = 'addition',
      input_varname = {'density','bg_density'},
    }          
  },
  {
    name = 'full_velocity',
    ncomponents = 3,
    vartype = 'operation',
    operation = {
      kind = 'addition',
      input_varname = {'velocity','bg_velocity'},
    }          
  },
  {
     name = 'full_pressure',
     ncomponents = 1,
     vartype = 'operation',
     operation = {
       kind = 'addition',
       input_varname = {'pressure','bg_pressure'},
     }          
  },
  {
     name = 'ref_pressure',
     ncomponents = 1,
     vartype ='st_fun',
     st_fun = { 
       predefined = 'acoustic_pulse',
       center     = gp_center,
       halfwidth  = gp_halfwidth,
       amplitude  = gp_amplitude,
       background = gp_background,
       speed_of_sound = gp_c,
     }
  },
  {
     name = 'error',
     ncomponents = 1,
     vartype = 'operation',
     operation = {
       kind = 'difference',
       input_varname = {'full_pressure', 'ref_pressure'},
    }
  },
  {
    name = 'coupling',
    ncomponents = 5,
    vartype = 'st_fun',
    st_fun = { 
      predefined = 'precice',
      precice_mesh = 'lineulerSurface',
      read_varname = {'density_euler', 
                       'velX_euler', 
                       'velY_euler', 
                       'velZ_euler', 
                       'pressure_euler'},
      write_varname = {'density_lineuler', 
                       'velX_lineuler', 
                       'velY_lineuler', 
                       'velZ_lineuler', 
                       'pressure_lineuler'},
    }          
  },
  -- write to precice
  {
     name = 'density_lineuler',
     ncomponents = 1,
     vartype = 'operation',
     operation = {
       kind = 'addition',
       input_varname = {'density','bg_density'},
     }          
  },
  {
     name = 'vel_lineuler',
     ncomponents = 3,
     vartype = 'operation',
     operation = {
       kind = 'addition',
       input_varname = {'velocity','bg_velocity'},
     }          
  },
  {
     name = 'velX_lineuler',
     ncomponents = 1,
     vartype = 'operation',
     operation = {
       kind = 'extract',
       input_varname = {'vel_lineuler'},
       input_varindex = {1}
     }          
  },
  {
     name = 'velY_lineuler',
     ncomponents = 1,
     vartype = 'operation',
     operation = {
       kind = 'extract',
       input_varname = {'vel_lineuler'},
       input_varindex = {2}
     }          
  },
  {
     name = 'velZ_lineuler',
     ncomponents = 1,
     vartype = 'operation',
     operation = {
       kind = 'extract',
       input_varname = {'vel_lineuler'},
       input_varindex = {3}
     }          
  },
  {
     name = 'pressure_lineuler',
     ncomponents = 1,
     vartype = 'operation',
     operation = {
       kind = 'addition',
       input_varname = {'pressure','bg_pressure'},
     }          
  },
  -- read from precice
  {
     name = 'density_euler',
     ncomponents = 1,
     vartype = 'operation',
     operation = {
       kind = 'extract',
       input_varname = 'coupling',
       input_varindex = {1}
     }          
  },
  {
     name = 'velX_euler',
     ncomponents = 1,
     vartype = 'operation',
     operation = {
       kind = 'extract',
       input_varname = 'coupling',
       input_varindex = {2}
     }          
  },
  {
     name = 'velY_euler',
     ncomponents = 1,
     vartype = 'operation',
     operation = {
       kind = 'extract',
       input_varname = 'coupling',
       input_varindex = {3}
     }          
  },
  {
     name = 'velZ_euler',
     ncomponents = 1,
     vartype = 'operation',
     operation = {
       kind = 'extract',
       input_varname = 'coupling',
       input_varindex = {4}
     }          
  },
  {
     name = 'pressure_euler',
     ncomponents = 1,
     vartype = 'operation',
     operation = {
       kind = 'extract',
       input_varname = 'coupling',
       input_varindex = {5}
     }          
  },
  {
     name = 'per_density_euler',
     ncomponents = 1,
     vartype = 'operation',
     operation = {
       kind = 'difference',
       input_varname = {'density_euler','bg_density'},
     }          
  },
  {
     name = 'velocity_euler',
     ncomponents = 3,
     vartype = 'operation',
     operation = {
       kind = 'combine',
       input_varname = {'velX_euler','velY_euler', 'velZ_euler'},
     }          
  },
  {
     name = 'per_vel_euler',
     ncomponents = 3,
     vartype = 'operation',
     operation = {
       kind = 'difference',
       input_varname = {'velocity_euler','bg_velocity'},
     }          
  },
  {
     name = 'per_velX_euler',
     ncomponents = 1,
     vartype = 'operation',
     operation = {
       kind = 'extract',
       input_varname = {'per_vel_euler'},
       input_varindex = {1}
     }          
  },
  {
     name = 'per_velY_euler',
     ncomponents = 1,
     vartype = 'operation',
     operation = {
       kind = 'extract',
       input_varname = {'per_vel_euler'},
       input_varindex = {2}
     }          
  },
  {
     name = 'per_velZ_euler',
     ncomponents = 1,
     vartype = 'operation',
     operation = {
       kind = 'extract',
       input_varname = {'per_vel_euler'},
       input_varindex = {2}
     }          
  },
  {
     name = 'per_pressure_euler',
     ncomponents = 1,
     vartype = 'operation',
     operation = {
       kind = 'difference',
       input_varname = {'pressure_euler','bg_pressure'},
     }          
  },
}

-- Mesh definitions --
mesh = 'mesh_lineuler/'

-- timing setting
timing_file = 'timing_lineuler.res'

-- Equation definitions --
equation = {
  name = 'LinearEuler',
  therm_cond = 2.555e-02,
  isen_coef = 1.4,
  background = {
    density =  bg_dens,
    velocityX = bg_velX,
    velocityY = bg_velY,
    velocityZ = bg_velZ,
    pressure = bg_press
  }
}

-- initial condition --
initial_condition = {
  density = 0.0, 
  velocityX = 0.0, 
  velocityY = 0.0,
  velocityZ = 0.0,
  pressure = 0.0, 
}

 -- Boundary definitions
boundary_condition = {
  {
    label = 'euler',
    kind = 'primitives',
    density = 'per_density_euler',
    velocityX = 'per_velX_euler', 
    velocityY = 'per_velY_euler',
    velocityZ = 'per_velZ_euler',
    pressure = 'per_pressure_euler',
  }
  ,
  {
    label = 'west',
    kind = 'primitives',
    density = 0.0,
    velocityX = 0.0, 
    velocityY = 0.0,
    velocityZ = 0.0,
    pressure = 0.0,
  }
  ,
  {
    label = 'east',
    kind = 'primitives',
    density = 0.0,
    velocityX = 0.0, 
    velocityY = 0.0,
    velocityZ = 0.0,
    pressure = 0.0,
  }
  ,
  {
    label = 'north',
    kind = 'primitives',
    density = 0.0,
    velocityX = 0.0, 
    velocityY = 0.0,
    velocityZ = 0.0,
    pressure = 0.0,
  }
  ,
  {
    label = 'south',
    kind = 'primitives',
    density = 0.0,
    velocityX = 0.0, 
    velocityY = 0.0,
    velocityZ = 0.0,
    pressure = 0.0,
  }
  ,
  {
    label = 'top',
    kind = 'primitives',
    density = 0.0,
    velocityX = 0.0, 
    velocityY = 0.0,
    velocityZ = 0.0,
    pressure = 0.0,
  }
  ,
  {
    label = 'bottom',
    kind = 'primitives',
    density = 0.0,
    velocityX = 0.0, 
    velocityY = 0.0,
    velocityZ = 0.0,
    pressure = 0.0,
  },
}
