require 'common'

logging = {level=7}

-- global simulation options
simulation_name='ateles_euler' 
sim_control = {
  time_control = {
    min = 0,
    max = tmax,
    interval = {iter = 100}, -- final simulation time
  }
}
-- table for preCICE
precice = {
           accessor = 'Ateles_euler',
           configFile ='precice_config.xml',
          }

-- Tracking
segments = 20*(degree+1)
NOtracking = {
  -- Line tracking
  {
    label = 'lineX_pressure',
    folder = './track_pulse/euler/',
    variable = {'pressure', 'ref_pressure', 'error'},
    shape = {
      kind = 'canoND',
      object = {
        -- close to center
        origin   = { -10.0, 0.0, 0.0 },
        vec      = { 20.0, 0.0 ,0.0},
        segments = { segments},
      },
    },
    time_control = {min = 0, max = tmax, interval = line_track_dt},
    output = { format = 'asciiSpatial', use_get_point = true},
  },
  {
    label = 'lineY_pressure',
    folder = './track_pulse/euler/',
    variable = {'pressure', 'ref_pressure', 'error'},
    shape = {
      kind = 'canoND',
      object = {
        -- close to center
        origin   = { 0.0, -10.0, 0.0 },
        vec      = { 0.0, 20.0 ,0.0},
        segments = { segments},
      },
    },
    time_control = {min = 0, max = tmax, interval = line_track_dt },
    output = { format = 'asciiSpatial', use_get_point = true},
  },
  {
    label = 'lineZ_pressure',
    folder = './track_pulse/euler/',
    variable = {'pressure', 'ref_pressure', 'error'},
    shape = {
      kind = 'canoND',
      object = {
        -- close to center
        origin   = { 0.0, 0.0, -10.0 },
        vec      = { 0.0, 0.0 ,20.0},
        segments = { segments},
      },
    },
    time_control = {min = 0, max = tmax, interval = line_track_dt},
    output = { format = 'asciiSpatial', use_get_point = true},
  },
  {
    label = 'center',
    folder = './track_pulse/euler/',
    variable = {'pressure', 'ref_pressure', 'error'},
    shape = {
      kind = 'canoND',
      object = {
        -- close to center
        { origin = { 0.0, 0.0, 0.0 }},
      },
    },
    time_control = {min = 0, max = tmax, interval = {iter=1}},
    output = { format = 'ascii', use_get_point = true},
  },
  {
    label = 'west',
    folder = './track_pulse/euler/',
    variable = {'pressure', 'ref_pressure', 'error'},
    shape = {
      kind = 'canoND',
      object = {
        -- point west 
        { origin = { -9.99,0.0, 0.0 }},
      },
    },
    time_control = {min = 0, max = tmax, interval ={iter=1} },
    output = { format = 'ascii', use_get_point = true},
  },
  {
    label = 'east',
    folder = './track_pulse/euler/',
    variable = {'pressure', 'ref_pressure', 'error'},
    shape = {
      kind = 'canoND',
      object = {
        -- point east 
        { origin = {  9.99, 0.0, 0.0 }},
      },
    },
    time_control = {min = 0, max = tmax, interval ={iter=1} },
    output = { format = 'ascii', use_get_point = true},
  },
  {
    label = 'south',
    folder = './track_pulse/euler/',
    variable = {'pressure', 'ref_pressure', 'error'},
    shape = {
      kind = 'canoND',
      object = {
        -- point south
        { origin = { 0.0, -9.99, 0.0 }},
      },
    },
    time_control = {min = 0, max = tmax, interval ={iter=1} },
    output = { format = 'ascii', use_get_point = true},
  },
  {
    label = 'north',
    folder = './track_pulse/euler/',
    variable = {'pressure', 'ref_pressure', 'error'},
    shape = {
      kind = 'canoND',
      object = {
        -- point north
        { origin = {  0.0, 9.99, 0.0}},
      },
    },
    time_control = {min = 0, max = tmax, interval ={iter=1} },
    output = { format = 'ascii', use_get_point = true},
  },
  {
    label = 'top',
    folder = './track_pulse/euler/',
    variable = {'pressure', 'ref_pressure', 'error'},
    shape = {
      kind = 'canoND',
      object = {
        -- point top
        { origin = {  0.0, 0.0, 9.99}},
      },
    },
    time_control = {min = 0, max = tmax, interval ={iter=1} },
    output = { format = 'ascii', use_get_point = true},
  },
  {
    label = 'bottom,',
    folder = './track_pulse/euler/',
    variable = {'pressure', 'ref_pressure', 'error'},
    shape = {
      kind = 'canoND',
      object = {
        -- point bottom
        { origin = {  0.0, 0.0, 9.99}},
      },
    },
    time_control = {min = 0, max = tmax, interval ={iter=1} },
    output = { format = 'ascii', use_get_point = true},
  },
  {
    label = 'northwesttop,',
    folder = './track_pulse/euler/',
    variable = {'pressure', 'ref_pressure', 'error'},
    shape = {
      kind = 'canoND',
      object = {
        -- point north west top
        { origin = {  9.99, 9.99, 9.99}},
      },
    },
    time_control = {min = 0, max = tmax, interval ={iter=1} },
    output = { format = 'ascii', use_get_point = true},
  },
}

-- Variable system definintion--
characteristic = 0.0
function relax_velocity(x,y,z,t)
  return {0.0, 0.0, 0.0}
end
relax_temperature = 0.0
variable = {
  {
     name = 'characteristic',
     ncomponents = 1,
     vartype = "st_fun",
     st_fun = characteristic
  },
  {
     name = 'relax_velocity',
     ncomponents = 3,
     vartype = "st_fun",
     st_fun = relax_velocity
  },
  {
     name = 'relax_temperature',
     ncomponents = 1,
     vartype = "st_fun",
     st_fun = relax_temperature
  },
  {
     name = 'ref_pressure',
     ncomponents = 1,
     vartype ='st_fun',
     st_fun = { 
       predefined = 'acoustic_pulse',
       center     = gp_center,
       halfwidth  = gp_halfwidth,
       amplitude  = gp_amplitude,
       background = gp_background,
       speed_of_sound = gp_c,
     }
  },
  {
     name = 'error',
     ncomponents = 1,
     vartype = 'operation',
     operation = {
       kind = 'difference',
       input_varname = {'pressure', 'ref_pressure'},
    }
  },
  {
     name = 'coupling',
     ncomponents = 5,
     vartype = 'st_fun',
     st_fun = { 
       predefined = 'precice',
       precice_mesh = 'eulerSurface',
       write_varname = {'density_euler', 
                        'velX_euler', 
                        'velY_euler', 
                        'velZ_euler', 
                        'pressure_euler'},
       read_varname = {'density_lineuler', 
                        'velX_lineuler', 
                        'velY_lineuler', 
                        'velZ_lineuler', 
                        'pressure_lineuler'},
     }          
   },
  -- write to precice
  {
     name = 'density_euler',
     ncomponents = 1,
     vartype = 'operation',
     operation = {
       kind = 'extract',
       input_varname = 'density',
       input_varindex = {1}
     }          
  },
  {
     name = 'velX_euler',
     ncomponents = 1,
     vartype = 'operation',
     operation = {
       kind = 'extract',
       input_varname = 'velocity',
       input_varindex = {1}
     }          
  },
  {
     name = 'velY_euler',
     ncomponents = 1,
     vartype = 'operation',
     operation = {
       kind = 'extract',
       input_varname = 'velocity',
       input_varindex = {2}
     }          
  },
  {
     name = 'velZ_euler',
     ncomponents = 1,
     vartype = 'operation',
     operation = {
       kind = 'extract',
       input_varname = 'velocity',
       input_varindex = {3}
     }          
  },
  {
     name = 'pressure_euler',
     ncomponents = 1,
     vartype = 'operation',
     operation = {
       kind = 'extract',
       input_varname = 'pressure',
       input_varindex = {1}
     }          
  },
  -- read from precice
  {
     name = 'density_lineuler',
     ncomponents = 1,
     vartype = 'operation',
     operation = {
       kind = 'extract',
       input_varname = 'coupling',
       input_varindex = {1}
     }          
  },
  {
     name = 'velX_lineuler',
     ncomponents = 1,
     vartype = 'operation',
     operation = {
       kind = 'extract',
       input_varname = 'coupling',
       input_varindex = {2}
     }          
  },
  {
     name = 'velY_lineuler',
     ncomponents = 1,
     vartype = 'operation',
     operation = {
       kind = 'extract',
       input_varname = 'coupling',
       input_varindex = {3}
     }          
  },
  {
     name = 'velZ_lineuler',
     ncomponents = 1,
     vartype = 'operation',
     operation = {
       kind = 'extract',
       input_varname = 'coupling',
       input_varindex = {4}
     }          
  },
  {
     name = 'pressure_lineuler',
     ncomponents = 1,
     vartype = 'operation',
     operation = {
       kind = 'extract',
       input_varname = 'coupling',
       input_varindex = {5}
     }          
  }
}

-- Mesh definitions --
mesh = 'mesh_euler/'

-- timing settings (i.e. output for performance measurements, this table is otional)
timing_file = 'timing_euler.res'         -- the filename of the timing results

-- Equation definitions --
equation = {
  name = 'euler',
  therm_cond = 2.555e-02,
  isen_coef = 1.4,
  r = 296.0,
  material = {
    characteristic = 'characteristic',
    relax_velocity = 'relax_velocity',
    relax_temperature = 'relax_temperature'
  }
}
-- (cv) heat capacity and (r) ideal gas constant
equation["cv"] = equation["r"] / (equation["isen_coef"] - 1.0)

-- initial condition --
initial_condition = {
  density = dens,
  velocityX = velX,
  velocityY = velY,
  velocityZ = velZ,
  pressure = { 
    predefined = 'gausspulse',
    center     = gp_center,
    halfwidth  = gp_halfwidth,
    amplitude  = gp_amplitude,
    background = gp_background
  },
}

 -- Boundary definitions
boundary_condition = {
  {
    label = 'west',
    kind = 'primitives',
    density = 'density_lineuler',
    velocityX = 'velX_lineuler', 
    velocityY = 'velY_lineuler',
    velocityZ = 'velZ_lineuler',
    pressure = 'pressure_lineuler',
  }
  ,
  {
    label = 'east',
    kind = 'primitives',
    density = 'density_lineuler',
    velocityX = 'velX_lineuler', 
    velocityY = 'velY_lineuler',
    velocityZ = 'velZ_lineuler',
    pressure = 'pressure_lineuler',
  }
  ,
  {
    label = 'north',
    kind = 'primitives',
    density = 'density_lineuler',
    velocityX = 'velX_lineuler', 
    velocityY = 'velY_lineuler',
    velocityZ = 'velZ_lineuler',
    pressure = 'pressure_lineuler',
  }
  ,
  {
    label = 'south',
    kind = 'primitives',
    density = 'density_lineuler',
    velocityX = 'velX_lineuler', 
    velocityY = 'velY_lineuler',
    velocityZ = 'velZ_lineuler',
    pressure = 'pressure_lineuler',
  }
  ,
  {
    label = 'top',
    kind = 'primitives',
    density = 'density_lineuler',
    velocityX = 'velX_lineuler', 
    velocityY = 'velY_lineuler',
    velocityZ = 'velZ_lineuler',
    pressure = 'pressure_lineuler',
  }
  ,
  {
    label = 'bottom',
    kind = 'primitives',
    density = 'density_lineuler',
    velocityX = 'velX_lineuler', 
    velocityY = 'velY_lineuler',
    velocityZ = 'velZ_lineuler',
    pressure = 'pressure_lineuler',
  }
}
