require 'common'
-- physical parameter ---------------------------------------------------------
initial_condition = {
  density = dens, 
  velocityX = velocityX,
  velocityY = velocityY,
  pressure = gauss_press, 
}

-- simulation controll parameter-----------------------------------------------
simulation_name='ateles_navier' 
timing_file = 'timing_navier.res'


-- Restart -------------------------------------------------------------------
restart = {
  read = './restart/navier/ateles_navier_header_200.000E-03.lua',
  write = './restart/navier/',
  time_control = {
    min = 0, 
    max = tmax, 
    interval = track_dt
  },
}

-- Tracking -------------------------------------------------------------------
NOtracking = {
  { -- GLobal VTK
    label = 'global',
    folder = './track/navier/',
    variable = {'density', 'momentum', 'energy', 'velocity', 'pressure'},
    shape = {
      { kind = 'all',}
    },
    time_control = {min = 0, max = tmax, interval = track_dt},
    output={format = 'vtk'},
  },
}

-- Simulation parameter -------------------------------------------------------
mesh = 'mesh_navier_split/'

-- Variable system definintion-------------------------------------------------
characteristic = 0.0
function relax_velocity(x,y,z,t)
  return {0.0, 0.0}
end
relax_temperature = 0.0

variable = {
  {
     name = 'characteristic',
     ncomponents = 1,
     vartype = "st_fun",
     st_fun = characteristic
  },
  {
     name = 'relax_velocity',
     ncomponents = 2,
     vartype = "st_fun",
     st_fun = relax_velocity
  },
  {
     name = 'relax_temperature',
     ncomponents = 1,
     vartype = "st_fun",
     st_fun = relax_temperature
  },
}

-- Equation definitions -------------------------------------------------------
penalization_eps = 8.0/(degree+1)
penalization_alpha = 1.0
equation = {
  penalization = {
    global = {
      kind = 'const',
      const = {0.0, 0.0, 0.0, 0.0},
    },
  },
  name       = 'navier_stokes_2d',
  isen_coef  = 1.4,
  r          = 280.0,
  therm_cond = 0.5, 
  mu         = 1.0e-4,  
  ip_param   = 4.0, 
  -- Parameters of the penalization
  porosity             = penalization_eps,
  viscous_permeability = penalization_alpha*penalization_eps,
  thermal_permeability = penalization_alpha*penalization_eps,
  material = {
    characteristic = 'characteristic',
    relax_velocity = 'relax_velocity',
    relax_temperature = 'relax_temperature'
  }
}
equation["cv"] = equation["r"] / (equation["isen_coef"] - 1.0)


 -- Boundary definitions
boundary_condition = {
  {
    label = 'fluid_east',
    kind = 'outflow',
    pressure = press,
  },
  {
    label = 'fluid_west',
    kind = 'outflow',
    pressure = press,
  },
  {
    label = 'fluid_north',
    kind = 'outflow',
    pressure = press,
  },
  {
    label = 'fluid_south',
    kind = 'outflow',
    pressure = press,
  },
  {
    label = 'fluid_top',
    kind = 'outflow',
    pressure = press,
  },
  {
    label = 'fluid_bottom',
    kind = 'outflow',
    pressure = press,
  },
}
